"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var ObjectPool = engine.ObjectPool;
var object_pool_init_1 = require("./object-pool-init");
var BreakUpPart_1 = require("./BreakUpPart");
var Turntable = (function (_super) {
    __extends(Turntable, _super);
    function Turntable() {
        var _this = _super.call(this) || this;
        _this._items = [];
        var wrapper = _this._wrapper = new engine.Container();
        _this.addChild(wrapper);
        var stickContainer = _this._stickContainer = new engine.Container();
        wrapper.addChild(stickContainer);
        var body = _this._body = new engine.Image();
        wrapper.addChild(body);
        var breakUpContainer = _this._breakUpContainer = new engine.Container();
        for (var i = 0, li = props_1.props.breakUpRatios.length - 1; i < li; i++) {
            var part = new BreakUpPart_1.BreakUpPart(_this, props_1.props.breakUpRatios[i], props_1.props.breakUpRatios[i + 1]);
            breakUpContainer.addChild(part);
        }
        breakUpContainer.visible = false;
        _this.addChild(breakUpContainer);
        return _this;
    }
    Turntable.prototype.resetAsset = function (body, asset) {
        body.source = asset;
        body.x = -body.width / 2;
        body.y = -body.height / 2;
        body.anchorX = -body.x;
        body.anchorY = -body.y;
    };
    Turntable.prototype.reset = function (options) {
        var turntableAssetName = options.turntableAssetName;
        this.rotationRange = props_1.props.rotationRange;
        var body = this._body;
        body.visible = true;
        this.resetAsset(body, turntableAssetName);
        this._radius = body.width / 2;
        this.hideSticks();
        for (var _i = 0, _a = this._breakUpContainer.children; _i < _a.length; _i++) {
            var part = _a[_i];
            this.resetAsset(part.body, turntableAssetName);
            part.updateMask();
        }
        this._breakUpContainer.visible = false;
    };
    Object.defineProperty(Turntable.prototype, "radius", {
        get: function () {
            return this._radius;
        },
        enumerable: true,
        configurable: true
    });
    Turntable.prototype.start = function () {
        this._dir = 1;
        this._items.splice(0);
        this.rotateOnce();
    };
    Turntable.prototype.pause = function () {
        engine.Tween.pauseTweens(this._wrapper);
    };
    Turntable.prototype.resume = function () {
        engine.Tween.resumeTweens(this._wrapper);
    };
    Turntable.prototype.addStick = function (stick) {
        var angle = this.parseAngle(this._wrapper.rotation);
        var minDis = props_1.props.stickAngle * 2;
        var hitOn = false;
        for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
            var item = _a[_i];
            if (Math.abs(item - angle) < minDis) {
                hitOn = true;
                break;
            }
        }
        if (hitOn) {
            this.pause();
        }
        else {
            this._items.push(angle);
            stick.anchorOffsetY = stick.y;
            stick.y = 0;
            stick.rotation = -this._wrapper.rotation;
            this._stickContainer.addChild(stick);
            this.shake();
        }
        return hitOn;
    };
    Turntable.prototype.parseAngle = function (r) {
        var round = r % 360;
        if (round < 0) {
            round += 360;
        }
        return round;
    };
    Turntable.prototype.hideSticks = function () {
        for (var _i = 0, _a = this._stickContainer.children; _i < _a.length; _i++) {
            var stick = _a[_i];
            ObjectPool.recycleObject(object_pool_init_1.PoolName, stick);
        }
        this._stickContainer.removeChildren();
    };
    Turntable.prototype.playBreakUp = function () {
        return __awaiter(this, void 0, void 0, function () {
            var p, _i, _a, part;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        this.pause();
                        this._body.visible = false;
                        this._breakUpContainer.visible = true;
                        for (_i = 0, _a = this._breakUpContainer.children; _i < _a.length; _i++) {
                            part = _a[_i];
                            p = part.playFall(this._wrapper.rotation);
                        }
                        return [4, p];
                    case 1:
                        _b.sent();
                        return [2];
                }
            });
        });
    };
    Turntable.prototype.shake = function () {
        engine.Tween.get(this, null, null, true)
            .to({ y: this.y - 5 }, 50)
            .to({ y: this.y }, 50);
    };
    Turntable.prototype.rotateOnce = function () {
        var _a = this.rotationRange, min = _a[0], max = _a[1];
        var dealtRotation = Math.random() * max + min;
        var duration = dealtRotation * (Math.random() * props_1.props.rotationDurationMultipleRandom + props_1.props.rotationDurationMultipleBase);
        var rotation = this._wrapper.rotation + this._dir * dealtRotation;
        this._dir *= -1;
        engine.Tween.get(this._wrapper, null, null, true)
            .to({ rotation: rotation }, duration)
            .call(this.rotateOnce, this);
    };
    return Turntable;
}(engine.Container));
exports.Turntable = Turntable;
