"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var Stick = (function (_super) {
    __extends(Stick, _super);
    function Stick() {
        var _this = _super.call(this) || this;
        var body = _this._body = new engine.Sprite(utils_1.getTextureByName('口红素材'));
        body.anchorY = _this._body.height / 2;
        body.x = -body.width / 2;
        _this.addChild(body);
        return _this;
    }
    Stick.prototype.reset = function () {
        this.visible = true;
        this.rotation = 0;
        this.anchorOffsetY = 0;
        var body = this._body;
        body.y = 0;
        body.rotation = 0;
    };
    Stick.prototype.playSend = function (y, callback) {
        this._toY = y;
        engine.Tween.get(this)
            .to({ y: y }, props_1.props.stickSendDuration)
            .call(callback);
    };
    Stick.prototype.stopSend = function () {
        engine.Tween.removeTweens(this);
    };
    Stick.prototype.playFall = function () {
        var _this = this;
        return new Promise(function (resolve) {
            engine.Tween.get(_this, null, null, true)
                .to({ rotation: 30, y: _this._toY + props_1.props.stickFallDistance }, 500, engine.Ease.cubicOut)
                .call(resolve);
        });
    };
    Object.defineProperty(Stick.prototype, "anchorOffsetY", {
        set: function (v) {
            this._body.y = v;
        },
        enumerable: true,
        configurable: true
    });
    return Stick;
}(engine.Container));
exports.Stick = Stick;
