"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var LisptickTurntable = (function (_super) {
    __extends(LisptickTurntable, _super);
    function LisptickTurntable() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('jump-high-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('jump-high-start', _this.start, _this);
        engine.globalEvent.addEventListener('jump-high-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('jump-high-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('jump-high-revive', _this.revive, _this);
        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    LisptickTurntable.prototype.reset = function () {
        this._gameView.reset();
    };
    LisptickTurntable.prototype.start = function (event) {
        if ('jump-high-start') {
            props_1.injectProps(event.data);
        }
        this._status = 1;
        this._gameView.start();
    };
    LisptickTurntable.prototype.pause = function () {
        this._gameView.pause();
    };
    LisptickTurntable.prototype.resume = function () {
        this._gameView.resume();
    };
    LisptickTurntable.prototype.revive = function () {
        this._gameView.revive();
    };
    LisptickTurntable.prototype.onTap = function (event) {
        this._gameView.jump();
    };
    return LisptickTurntable;
}(engine.Container));
exports.LisptickTurntable = LisptickTurntable;
