"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var GoldBag = (function (_super) {
    __extends(GoldBag, _super);
    function GoldBag() {
        var _this = _super.call(this) || this;
        _this.setup();
        return _this;
    }
    GoldBag.prototype.setup = function () {
        var svga = this.svga = utils_1.createSvga('钱袋', 'goldPackAnchor');
        this.addChild(svga);
    };
    GoldBag.prototype.reset = function (data) {
        this.y = data.y;
        this.svga.visible = true;
        this.svga.gotoAndStop(1);
    };
    GoldBag.prototype.playOpen = function () {
        var _this = this;
        return new Promise(function (resolve) {
            _this.svga.play(true, false);
            _this.svga.once(engine.Event.END_FRAME, function () {
                this.svga.visible = false;
                resolve();
            }, _this);
        });
    };
    return GoldBag;
}(engine.Container));
exports.GoldBag = GoldBag;
