"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var GameWrapper = (function (_super) {
    __extends(GameWrapper, _super);
    function GameWrapper() {
        var _this = _super.call(this) || this;
        _this.onAddedToStage = function () {
            var p = _this.globalToLocal(new engine.Point());
            var touchLayer = _this._touchLayer;
            touchLayer.x = p.x;
            touchLayer.y = p.y;
            touchLayer.width = engine.gameStage.width;
            touchLayer.height = engine.gameStage.height;
        };
        engine.globalEvent.addEventListener('lipstick-turntable-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-start', _this.start, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-revive', _this.revive, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-clear', _this.clear, _this);
        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        var touchLayer = _this._touchLayer = new engine.Container();
        _this.addChild(touchLayer);
        setTimeout(_this.onAddedToStage, 100);
        return _this;
    }
    GameWrapper.prototype.reset = function (event) {
        props_1.injectProps(event.data);
        this._gameView.visible = true;
        this._gameView.reset(false, event.data);
    };
    GameWrapper.prototype.start = function (event) {
        props_1.injectProps(event.data);
        this._status = 1;
        this._gameView.start();
    };
    GameWrapper.prototype.pause = function () {
        this._gameView.pause();
    };
    GameWrapper.prototype.resume = function () {
        this._gameView.resume();
    };
    GameWrapper.prototype.revive = function () {
        this._gameView.revive();
    };
    GameWrapper.prototype.clear = function () {
        this._gameView.visible = false;
    };
    GameWrapper.prototype.onTap = function (event) {
        this._gameView.tap(event);
    };
    return GameWrapper;
}(engine.Container));
exports.GameWrapper = GameWrapper;
