"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var GuideLayer_1 = require("./GuideLayer");
var ObjectPool = engine.ObjectPool;
var Turntable_1 = require("./Turntable");
var object_pool_init_1 = require("./object-pool-init");
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.countDownStep = function (decrease) {
            if (decrease === void 0) { decrease = true; }
            if (decrease) {
                _this._countdown--;
                if (_this._countdown <= 0) {
                    _this.stopCountDown();
                    _this.onTimeout();
                }
            }
            engine.globalEvent.dispatchEvent('lipstick-turntable-countdown', {
                second: _this._countdown,
            });
        };
        _this.onHit = function () { return __awaiter(_this, void 0, void 0, function () {
            var stick;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        stick = this._stick;
                        if (!this.turntable.addStick(stick)) return [3, 2];
                        this.stopCountDown();
                        return [4, stick.playFall()];
                    case 1:
                        _a.sent();
                        engine.globalEvent.dispatchEvent('lipstick-turntable-game-failed', {
                            reason: 2,
                        });
                        return [3, 5];
                    case 2:
                        this._counting--;
                        engine.globalEvent.dispatchEvent('lipstick-turntable-hit', {
                            remain: this._counting,
                        });
                        if (!(this._counting === 0)) return [3, 4];
                        this.turntable.hideSticks();
                        this.stopCountDown();
                        return [4, this.turntable.playBreakUp()];
                    case 3:
                        _a.sent();
                        engine.globalEvent.dispatchEvent('lipstick-turntable-game-success');
                        return [3, 5];
                    case 4:
                        this.prepareStick();
                        _a.label = 5;
                    case 5: return [2];
                }
            });
        }); };
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        var turntable = this.turntable = new Turntable_1.Turntable();
        this.addChild(turntable);
        var guideLayer = this.guideLayer = new GuideLayer_1.GuideLayer();
        this.addChild(guideLayer);
    };
    GameView.prototype.reset = function (revive, options) {
        if (revive === void 0) { revive = false; }
        if (options === void 0) { options = null; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (options) {
                    this.turntable.reset(options);
                    this.recycleStick();
                }
                else {
                    this.prepareStick();
                }
                return [2];
            });
        });
    };
    GameView.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this._countdown = props_1.props.countDown;
                this._counting = props_1.props.lipstickCount;
                this.turntable.start();
                this.prepareStick();
                this.countDownStep(false);
                this.startCountDown();
                return [2];
            });
        });
    };
    GameView.prototype.startCountDown = function () {
        this._timer = setInterval(this.countDownStep, 1000);
    };
    GameView.prototype.stopCountDown = function () {
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
    };
    GameView.prototype.prepareStick = function () {
        var stick = this._stick = ObjectPool.getObject(object_pool_init_1.PoolName);
        stick.y = props_1.props.stickDistance;
        this.addChildAt(stick, 0);
        this._touchEnabled = true;
    };
    GameView.prototype.recycleStick = function () {
        var stick = this._stick;
        if (stick) {
            this._stick = null;
            this.removeChild(stick);
            ObjectPool.recycleObject(object_pool_init_1.PoolName, stick);
        }
    };
    GameView.prototype.pause = function () {
        this.turntable.pause();
        this._stick.stopSend();
        this._stick.playFall();
        this.stopCountDown();
    };
    GameView.prototype.resume = function () {
        this.recycleStick();
        this.turntable.resume();
        this.startCountDown();
    };
    GameView.prototype.revive = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.recycleStick();
                this.prepareStick();
                this.turntable.resume();
                return [2];
            });
        });
    };
    GameView.prototype.onTimeout = function () {
        this.pause();
        this._touchEnabled = false;
        engine.globalEvent.dispatchEvent('lipstick-turntable-game-failed', {
            reason: 1,
        });
    };
    GameView.prototype.tap = function (e) {
        if (!this._touchEnabled) {
            return;
        }
        this._touchEnabled = false;
        this._stick.playSend(this.turntable.radius - props_1.props.stickInsertDepth, this.onHit);
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
