"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var BreakUpPart = (function (_super) {
    __extends(BreakUpPart, _super);
    function BreakUpPart(turntable, from, to) {
        var _this = _super.call(this) || this;
        var body = _this._body = new engine.Image();
        _this.addChild(body);
        var mask = _this._body.mask = new engine.Graphics();
        _this.addChild(mask);
        _this._turntable = turntable;
        _this._from = from;
        _this._to = to;
        _this._fromR = from * Math.PI / 180;
        _this._toR = to * Math.PI / 180;
        return _this;
    }
    BreakUpPart.prototype.updateMask = function () {
        var mask = this._body.mask;
        mask.beginFill(0xff0000);
        mask.moveTo(0, 0);
        mask.arc(0, 0, this._turntable.radius + 5, this._fromR, this._toR);
        mask.endFill();
        var _a = props_1.props.breakUpDistanceRange, min = _a[0], max = _a[1];
        var mid = (this._toR - this._fromR) / 2 + this._fromR;
        this.x = Math.cos(mid) * Math.random() * max + min;
        this.y = Math.sin(mid) * Math.random() * max + min;
        this.alpha = 1;
        this.rotation = 0;
    };
    BreakUpPart.prototype.playFall = function (rotation) {
        var _this = this;
        this._body.rotation = rotation;
        return new Promise(function (resolve) {
            var angle = (_this._to - _this._from) / 2 + _this._from;
            var rotation = (angle > 270 ? 360 : 0) + 90 - angle;
            engine.Tween.get(_this, null, null, true)
                .to({ y: _this.y + props_1.props.turntableFallDistance, alpha: 0, rotation: rotation }, props_1.props.turntableFallDuration, engine.Ease.cubicIn)
                .call(resolve);
        });
    };
    Object.defineProperty(BreakUpPart.prototype, "body", {
        get: function () {
            return this._body;
        },
        enumerable: true,
        configurable: true
    });
    return BreakUpPart;
}(engine.Container));
exports.BreakUpPart = BreakUpPart;
