"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var Block = (function (_super) {
    __extends(Block, _super);
    function Block() {
        var _this = _super.call(this) || this;
        var body = _this.body = new svga.Svga();
        body.x = -props_1.props.blockWidth / 2;
        body.y = -props_1.props.blockHitHeight - props_1.props.blockPaddingTop;
        _this.addChild(body);
        return _this;
    }
    Block.prototype.reset = function (_a) {
        var type = _a.type;
        this.dir = Math.random() > 0.5 ? 1 : -1;
        if (this.type != type) {
            this.type = type;
            var asset_1 = utils_1.getBlockAsset(type);
            this.body.source = 'asset://' + asset_1.uuid;
        }
        this.scaleX = this.dir;
        this.body.gotoAndStop(1);
    };
    Block.prototype.playEnter = function (index, animation) {
        var _this = this;
        this.visible = true;
        this.x = this.dir * this.stage.width;
        var _a = props_1.props.blockSpeedRange, min = _a[0], max = _a[1];
        var duration = Math.max(max - index * 10, min);
        return new Promise(function (resolve) {
            if (animation) {
                engine.Tween.get(_this, null, null, true)
                    .to({ x: 0, }, duration)
                    .call(resolve);
            }
            else {
                _this.x = 0;
                setTimeout(function () {
                    console.log(_this.body);
                }, 200);
                resolve();
            }
        });
    };
    Block.prototype.playLeave = function () {
        this.visible = false;
    };
    Block.prototype.playEffect = function () {
        this.body.play(true, false);
    };
    Block.prototype.stop = function () {
        engine.Tween.removeTweens(this);
    };
    return Block;
}(engine.Container));
exports.default = Block;
