"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var svgaAssets = {
    aniReady: { name: '准备立正', dir: 1 },
    aniJump: { name: '跳上升', dir: 1 },
    aniFall: { name: '跳下落', dir: 1 },
    aniLandNormal: { name: '普通着地', dir: 1 },
    aniLandSide: { name: '边缘着地', dir: -1 },
    aniHit: { name: '被撞开', dir: -1 },
    aniParachute: { name: '降落', dir: -1 },
};
var Player = (function (_super) {
    __extends(Player, _super);
    function Player() {
        var _this = _super.call(this) || this;
        _this.g = props_1.props.gravity;
        _this.addEventListener(engine.Event.ENTER_FRAME, _this.onEnterFrame, _this);
        return _this;
    }
    Player.prototype.switchAni = function (name, dir, play, loop) {
        var _this = this;
        if (dir === void 0) { dir = 1; }
        if (play === void 0) { play = true; }
        if (loop === void 0) { loop = false; }
        return new Promise(function (resolve) {
            _this.scaleX = dir;
            if (_this._aniName !== name) {
                _this._aniName = name;
                var oldAni = _this.removeChild(_this.getChildByName('body'));
                if (oldAni) {
                    oldAni.stop();
                }
                var ani = _this._currentAni = _this['ani' + name];
                _this.addChild(ani);
                if (play) {
                    ani.play(false, loop);
                    if (loop) {
                        resolve();
                    }
                    else {
                        ani.once(engine.Event.END_FRAME, resolve);
                    }
                }
                else {
                    ani.gotoAndStop(1);
                    resolve();
                }
            }
        });
    };
    Player.prototype.setup = function () {
        this.prefectEffect = utils_1.createSvga('完美着地特效', 'playerLandPrefectAnchor');
        this.landEffect = utils_1.createSvga('着地特效', 'playerLandEffectAnchor');
        for (var key_1 in svgaAssets) {
            var _a = svgaAssets[key_1], name_1 = _a.name, dir = _a.dir;
            var body = this[key_1] = utils_1.createSvga(name_1, key_1.replace('ani', 'player') + 'Anchor');
            body.name = 'body';
            body.scaleX = dir;
        }
    };
    Player.prototype.reset = function (revive) {
        this.x = 0;
        this.rotation = 0;
        this.scaleX = this.scaleY = 1;
        this._prefectLandCounting = 0;
        engine.Tween.removeTweens(this);
        if (revive) {
            this.switchAni('Jump', 1, false);
        }
    };
    Player.prototype.playReady = function () {
        var _this = this;
        return new Promise(function (resolve) {
            _this.switchAni('Ready', 1);
            _this._currentAni.once(engine.Event.END_FRAME, function () {
                this.switchAni('Jump', 1, false);
                resolve();
            }, _this);
        });
    };
    Player.prototype.onEnterFrame = function (event) {
        if (!this.playing) {
            return;
        }
        this.vy += this.g;
        this.y += this.vy;
        if (this.vy > 0 && this._aniName !== 'Fall') {
            this.dispatchEvent('jump-on-top');
            this.switchAni('Fall');
        }
        if (this.y > this.baseY) {
            this.y = this.baseY;
            this.playing = false;
            this.jumpPromise && this.jumpPromise({
                aboveBlock: this.aboveBlock,
            });
            this.jumpPromise = null;
        }
    };
    Player.prototype.changeBaseY = function (v) {
        if (this.baseY == v) {
            return;
        }
        this.aboveBlock = true;
        this.baseY = v;
    };
    Player.prototype.jump = function () {
        var _this = this;
        utils_1.playSound('跳起音效');
        this.switchAni('Jump', 1, false);
        this._currentAni.play(false, false);
        this.aboveBlock = false;
        this.playing = true;
        this.baseY = this.y;
        this.vy = -props_1.props.jumpSpeed;
        return new Promise(function (resolve) {
            _this.jumpPromise = resolve;
        });
    };
    Player.prototype.playLand = function (type, dir) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, prefectEffect_1, landEffect_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = type;
                        switch (_a) {
                            case 0: return [3, 1];
                            case 1: return [3, 3];
                            case 2: return [3, 3];
                            case 3: return [3, 4];
                        }
                        return [3, 5];
                    case 1:
                        this._prefectLandCounting++;
                        utils_1.playSound('完美落地音效' + Math.min(4, this._prefectLandCounting));
                        prefectEffect_1 = this.prefectEffect;
                        this.addChildAt(prefectEffect_1, 0);
                        prefectEffect_1.gotoAndPlay(1);
                        prefectEffect_1.once(engine.Event.END_FRAME, function () {
                            this.removeChild(prefectEffect_1);
                        }, this);
                        landEffect_1 = this.landEffect;
                        this.addChildAt(landEffect_1, 0);
                        landEffect_1.gotoAndPlay(1);
                        landEffect_1.once(engine.Event.END_FRAME, function () {
                            this.removeChild(landEffect_1);
                        }, this);
                        return [4, this.switchAni('LandNormal')];
                    case 2:
                        _b.sent();
                        return [3, 5];
                    case 3:
                        this._prefectLandCounting = 0;
                        utils_1.playSound('普通落地音效');
                        this.switchAni('LandNormal');
                        return [3, 5];
                    case 4:
                        this._prefectLandCounting = 0;
                        utils_1.playSound('边缘落地音效');
                        this.switchAni('LandSide', dir);
                        return [3, 5];
                    case 5: return [2];
                }
            });
        });
    };
    Player.prototype.hitAway = function (dir) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.jumpPromise && this.jumpPromise();
                        this.jumpPromise = null;
                        utils_1.playSound('被撞开音效');
                        this.switchAni('Hit', dir);
                        this.vy = 0;
                        return [4, new Promise(function (resolve) {
                                engine.Tween.get(_this)
                                    .to({
                                    x: -dir * props_1.props.hitAwayDistance.x,
                                }, props_1.props.hitAwayDuration, engine.Ease.quartOut);
                                engine.Tween.get(_this)
                                    .to({
                                    y: _this.y + props_1.props.hitAwayDistance.y,
                                }, props_1.props.hitAwayDuration, engine.Ease.cubicOut)
                                    .call(resolve);
                            })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    Player.prototype.parachute = function (dir) {
        var _this = this;
        this.switchAni('Parachute', dir);
        return new Promise(function (resolve) {
            engine.Tween.get(_this)
                .wait(200)
                .call(function () {
                utils_1.playSound('降落伞下落音效');
            })
                .wait(300)
                .to({ y: _this.y + props_1.props.parachuteDistance }, props_1.props.parachuteDuration)
                .set({ anchorOffsetY: 0 })
                .call(resolve);
        });
    };
    return Player;
}(engine.Container));
exports.default = Player;
