"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var GoldBag = (function (_super) {
    __extends(GoldBag, _super);
    function GoldBag() {
        var _this = _super.call(this) || this;
        _this.setup();
        return _this;
    }
    GoldBag.prototype.setup = function () {
        var avatar = this.avatar = new engine.Sprite(utils_1.getTextureByName('钱袋-静态'));
        avatar.x = -props_1.props.goldPackAvatarAnchor.x;
        avatar.y = -props_1.props.goldPackAvatarAnchor.y;
        this.addChild(avatar);
        var svga = this.svga = utils_1.createSvga('钱袋', 'goldPackAnchor');
        svga.visible = false;
        this.addChild(svga);
    };
    GoldBag.prototype.reset = function (data) {
        this.y = data.y;
        this.avatar.visible = true;
        this.svga.visible = false;
        this.svga.gotoAndStop(1);
        this.remain = data.remain;
    };
    GoldBag.prototype.playOpen = function () {
        var _this = this;
        this.avatar.visible = false;
        this.svga.visible = true;
        return new Promise(function (resolve) {
            _this.svga.play(true, false);
            _this.svga.once(engine.Event.END_FRAME, function () {
                this.svga.visible = false;
                resolve();
            }, _this);
        });
    };
    return GoldBag;
}(engine.Container));
exports.GoldBag = GoldBag;
