"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var ObjectPool = engine.ObjectPool;
var object_pool_init_1 = require("./object-pool-init");
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.goodsItems = [];
        _this.moveCatchX = 0;
        _this.playerCatchX = 0;
        _this.onDownStage = function (e) {
            _this.moveCatchX = e.localX;
            _this.playerCatchX = _this.player.x;
        };
        _this.onMoveStage = function (e) {
            if (_this.gameIng) {
                _this.player.x = _this.playerCatchX + (e.localX - _this.moveCatchX);
            }
        };
        _this.onOutStage = function (e) {
            _this.moveCatchX = 0;
        };
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        var _this = this;
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        this.NpcBg = new engine.Container();
        this.NpcBg.alpha = 1;
        this.NpcBg.width = 0;
        this.NpcBg.height = 0;
        this.addChild(this.NpcBg);
        this.player = new engine.Container();
        this.player.mouseEnabled = false;
        this.addChild(this.player);
        this.waterSvga = utils_1.createSvga("水花");
        this.playerSvga = utils_1.createSvga("玩家");
        this.boomSvga = utils_1.createSvga("炸弹svga");
        this.player.addChild(this.playerSvga);
        this.player.addChild(this.waterSvga);
        this.player.addChild(this.boomSvga);
        this.playerSvga.gotoAndPlay(1);
        this.visible = false;
        setTimeout(function () {
            _this.visible = true;
            _this.player.anchorY = _this.player.height / 2;
            _this.player.anchorX = _this.player.width / 2;
            console.log(_this.player.width);
            console.log(_this.playerSvga.width);
            _this.player.x = 375 - _this.player.width / 2;
            _this.player.y = props_1.props.playerPositionY;
        }, 300);
        this.rectBg = new engine.Rect();
        this.rectBg.alpha = 0;
        this.rectBg.width = 750;
        this.rectBg.height = 1624;
        this.addChild(this.rectBg);
        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDownStage, this);
        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMoveStage, this);
        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_OUT, this.onOutStage, this);
    };
    GameView.prototype.reset = function () {
        this.recycleGoods();
    };
    GameView.prototype.start = function () {
        var _this = this;
        this.score = 0;
        this.speed = 1;
        this.gameIng = true;
        this.creatNpc();
        this.beginNpc();
        this.countdown = props_1.props.countDown;
        this.countdownTimer = setInterval(function () {
            if (_this.gameIng) {
                if (_this.countdown > 0) {
                    engine.globalEvent.dispatchEvent('food-fell-time-update', {
                        time: _this.countdown,
                    });
                    _this.countdown -= 1;
                }
                else {
                    engine.globalEvent.dispatchEvent('food-fell-game-over', {
                        score: _this.score,
                        reason: 1
                    });
                    _this.died();
                }
            }
        }, 1000);
    };
    GameView.prototype.beginNpc = function () {
        var _this = this;
        this.timer = setTimeout(function () {
            if (_this.gameIng) {
                _this.speed += props_1.props.acceleratedSpeed;
                _this.creatNpc();
            }
            _this.beginNpc();
        }, 2000 / this.speed);
    };
    GameView.prototype.pause = function () {
        this.gameIng = false;
    };
    GameView.prototype.revive = function () {
        this.gameIng = true;
    };
    GameView.prototype.resume = function () {
        this.reset();
        this.start();
    };
    GameView.prototype.creatNpc = function () {
        var _this = this;
        var goods = this._goods = ObjectPool.getObject(object_pool_init_1.PoolName);
        this.goodsItems.push(goods);
        this.NpcBg.addChild(goods);
        goods.addEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"] = function () {
            if (goods.y > 1624) {
                _this.removeNpc(goods);
            }
            else {
                if (_this.gameIng) {
                    goods.y += (4 * _this.speed);
                    if (_this.hasHit(_this.player, goods)) {
                        if (goods["npcType"] == "rain") {
                            console.log("碰到雨滴");
                            _this.score += props_1.props.rainScore;
                            _this.waterSvga.visible = true;
                            _this.waterSvga.play(false, false);
                            _this.waterSvga.once(engine.Event.END_FRAME, function () {
                                _this.waterSvga.visible = false;
                            }, _this);
                        }
                        else if (goods["npcType"] == "stone") {
                            console.log("碰到石头");
                            _this.score += props_1.props.stoneScore;
                        }
                        else if (goods["npcType"] == "boom") {
                            console.log("碰到炸弹");
                            _this.boomSvga.visible = true;
                            _this.boomSvga.play(false, false);
                            _this.boomSvga.once(engine.Event.END_FRAME, function () {
                                _this.boomSvga.visible = false;
                            }, _this);
                            engine.globalEvent.dispatchEvent('food-fell-game-over', {
                                score: _this.score,
                                reason: 2
                            });
                            _this.died();
                        }
                        engine.globalEvent.dispatchEvent('food-fell-score-update', {
                            score: _this.score,
                        });
                        _this.removeNpc(goods);
                    }
                }
            }
        }, this);
    };
    GameView.prototype.died = function () {
        this.score = 0;
        this.pause();
    };
    GameView.prototype.removeNpc = function (goods) {
        this.NpcBg.removeChild(goods);
        ObjectPool.recycleObject(object_pool_init_1.PoolName, goods);
        goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
        var index = this.goodsItems.indexOf(goods);
        if (index > -1) {
            this.goodsItems.splice(index, 1);
        }
    };
    GameView.prototype.recycleGoods = function () {
        clearTimeout(this.timer);
        clearInterval(this.countdownTimer);
        for (var _i = 0, _a = this.goodsItems; _i < _a.length; _i++) {
            var goods = _a[_i];
            if (goods) {
                this.removeChild(goods);
                ObjectPool.recycleObject(object_pool_init_1.PoolName, goods);
                goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
            }
        }
        this.goodsItems = [];
    };
    GameView.prototype.hasHit = function (a, b) {
        if (Math.abs((a.x + a.width / 2) - (b.x + b.width / 2)) < a.width / 2 + b.width / 2
            &&
                Math.abs((a.y + a.height / 2) - (b.y + b.height / 2)) < a.height / 2 + b.height / 2) {
            return true;
        }
        else {
            return false;
        }
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
