"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var Strut = (function (_super) {
    __extends(Strut, _super);
    function Strut() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Strut.prototype.init = function () {
        this._strut = new engine.Rect();
        this.addChild(this._strut);
        this._strut.width = props_1.props.strutWidth;
        this._strut.y = 833;
        this._strut.fillColor = props_1.props.strutColor;
        this._strut.rotation = 180;
    };
    Strut.prototype.onMouseDown = function (pierWidth, distance, callBack) {
        this._strut.x = pierWidth - 60;
        this._distance = distance;
        this._callBack = callBack;
        this._strut.visible = true;
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameStrut, this);
    };
    Strut.prototype.onMouseUp = function () {
        var _this = this;
        this.removeEventListener(engine.Event.ENTER_FRAME, this.frameStrut, this);
        setTimeout(function () {
            _this.strutRotation();
        }, 200);
    };
    Strut.prototype.strutRotation = function () {
        var _this = this;
        engine.Tween.get(this._strut, { loop: false })
            .to({ rotation: 270 }, props_1.props.strutRotationSpeed)
            .call(function () {
            _this.judgeResult();
            engine.Tween.removeTweens(_this._strut);
        });
    };
    Strut.prototype.judgeResult = function () {
        var isSuccess = false;
        if (this._distance[0] - this._distance[1] + 100 <= this._strut.height && this._strut.height <= this._distance[0] + 20) {
            isSuccess = true;
        }
        if (this._callBack) {
            this._callBack(isSuccess);
        }
    };
    Strut.prototype.frameStrut = function () {
        if (this._strut.height < 1000) {
            this._strut.height += props_1.props.strutUpSpeed;
        }
    };
    Strut.prototype.rest = function () {
        this._strut.width = props_1.props.strutWidth;
        this._strut.y = 833;
        this._strut.fillColor = props_1.props.strutColor;
        this._strut.rotation = 180;
        this._strut.height = 0;
        this._strut.visible = false;
    };
    Strut.prototype.getStrutHeight = function () {
        var distance = this._strut.height > 1000 ? 1000 : this._strut.height;
        return distance;
    };
    return Strut;
}(engine.Container));
exports.Strut = Strut;
