"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("./../props");
var ObjectPool = engine.ObjectPool;
var Road = (function (_super) {
    __extends(Road, _super);
    function Road() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Road.prototype.setup = function () {
        this.lastPos = 0;
        this.addPier();
    };
    Road.prototype.getFristPier = function () {
        return this.getChildAt(0).width;
    };
    Road.prototype.getDistance = function () {
        var distance = [];
        var pier1 = this.getChildAt(0);
        var pier2 = this.getChildAt(1);
        distance.push(pier2.x - pier1.x);
        distance.push(pier2.width);
        return distance;
    };
    Road.prototype.addPier = function () {
        while (this.children.length < props_1.props.pierCount + 1) {
            var childrenNum = this.children.length;
            var randomPos = this.makeRandomFloat(props_1.props.pierMaxDistance, props_1.props.pierMinDistance);
            var pier = ObjectPool.getObject('pier');
            this.addChild(pier);
            if (childrenNum == 0) {
                pier.x = 0;
            }
            else {
                pier.x = this.lastPos + randomPos;
            }
            this.lastPos = pier.x;
        }
    };
    Road.prototype.moveAddPier = function () {
        var randomPos = this.makeRandomFloat(props_1.props.pierMaxDistance, props_1.props.pierMinDistance);
        var pier = ObjectPool.getObject('pier');
        var lastChild = this.getChildAt(this.children.length - 1);
        pier.x = lastChild.x + randomPos;
        this.addChild(pier);
    };
    Road.prototype.makeRandomFloat = function (max, min) {
        if (min === void 0) { min = 0; }
        return Math.random() * (max - min) + min;
    };
    Road.prototype.setViewport = function () {
        var _this = this;
        var tmpMovepos = this.getMovePos();
        this.children.forEach(function (item, index) {
            _this.playTween(item, index, tmpMovepos);
        });
    };
    Road.prototype.getMovePos = function () {
        var movePos = this.getChildAt(1);
        return movePos.x;
    };
    Road.prototype.playTween = function (item, index, tmpMovepos) {
        var _this = this;
        engine.Tween.get(item, { loop: false })
            .to({ x: item.x - tmpMovepos }, props_1.props.pierMoveTime)
            .call(function () {
            if (_this.getChildIndex(item) == 0) {
                engine.Tween.removeTweens(item);
                _this.removeChild(item);
                ObjectPool.recycleObject('pier', item);
            }
            if (index == 0) {
                _this.moveAddPier();
            }
        });
    };
    Road.prototype.getStartGold = function (index, isClose) {
        if (isClose === void 0) { isClose = true; }
        var tmpNode = this.getChildAt(index);
        var haveGold = tmpNode.haveGold;
        if (haveGold && isClose) {
            tmpNode.closeGold();
        }
        return haveGold;
    };
    Road.prototype.setGuide = function () {
        var tmpNode = this.getChildAt(1);
        if (!tmpNode.haveGold) {
            tmpNode.children.forEach(function (item) {
                if (item.name == 'gold') {
                    item.visible = true;
                }
            });
            tmpNode.haveGold = true;
        }
    };
    return Road;
}(engine.Container));
exports.Road = Road;
