"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var GuideLayer = (function (_super) {
    __extends(GuideLayer, _super);
    function GuideLayer() {
        var _this = _super.call(this) || this;
        _this._canClear = [];
        _this.setup();
        return _this;
    }
    GuideLayer.prototype.setup = function () {
    };
    GuideLayer.prototype.show = function (id, options, callback) {
        this.visible = true;
        this._callBack = callback ? callback : null;
        if (!this.guideMask) {
            this._options = options;
            var _a = this.stage, width = _a.width, height = _a.height;
            var guideMask = this.guideMask = new engine.Container();
            var guideHole = this._guideHole = new engine.Image(utils_1.getTextureByName('guide'));
            guideHole.x = options.x;
            guideHole.y = options.y;
            guideHole.width = 250;
            guideHole.height = 250;
            guideHole.name = 'guideHole';
            guideMask.addChild(guideHole);
            this.createRect(guideMask, 0, 0, width, guideHole.y);
            this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
            this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
            this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
            this.guideStep(id);
            var label = this.label = new engine.Label();
            label.fillColor = 'white';
            label.size = 30;
            label.text = options.guideText;
            label.x = (width - label.width) / 2;
            label.y = guideHole.y + guideHole.height + 50;
            label.textAlign = engine.TEXT_ALIGN.CENTER;
            label.name = 'labHint';
            guideMask.addChild(label);
            this.addChild(guideMask);
        }
        this.once(engine.MouseEvent.CLICK, function () {
            this.removeChild(this.guideMask);
            this.guideMask = null;
            if (this._callBack) {
                this._callBack();
            }
        }, this);
    };
    GuideLayer.prototype.createRect = function (container, x, y, width, height) {
        var rect = new engine.Rect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        rect.fillColor = 'black';
        rect.alpha = 0.7;
        container.addChild(rect);
    };
    GuideLayer.prototype.guideStep = function (id) {
        if (id == 1) {
            var guideHand = new engine.Image(utils_1.getTextureByName('guideHand'));
            guideHand.x = this._options.x + 300;
            guideHand.y = this._options.y + 100;
            this.guideMask.addChild(guideHand);
            var rect = new engine.Rect();
            rect.x = this._options.x + 200;
            rect.y = this._options.y - 15;
            rect.width = props_1.props.strutWidth;
            rect.height = 200;
            rect.fillColor = props_1.props.strutColor;
            this.guideMask.addChild(rect);
            this._canClear.push(guideHand);
            this._canClear.push(rect);
        }
        if (id == 2) {
            var know = new engine.Image(utils_1.getTextureByName('know'));
            know.x = (this.stage.width - know.width) / 2;
            know.y = this._options.y + 400;
            this.guideMask.addChild(know);
            this._canClear.push(know);
        }
    };
    return GuideLayer;
}(engine.Container));
exports.GuideLayer = GuideLayer;
