"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Road_1 = require("./Road");
var props_1 = require("../props");
var utils_1 = require("./utils");
var GuideLayer_1 = require("./GuideLayer");
var Background_1 = require("./Background");
var ObjectPool = engine.ObjectPool;
var Pier_1 = require("./Pier");
var Player_1 = require("./Player");
var Strut_1 = require("./Strut");
var ScoreLabel_1 = require("./ScoreLabel");
exports.PoolName = 'pier';
ObjectPool.registerPool(exports.PoolName, function () {
    return new Pier_1.Pier();
}, function (item, data) {
    item.init();
});
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.moveX = 0;
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        this._backgroud = new Background_1.Background();
        this.addChild(this._backgroud);
        this._backgroud.initBg();
        var road = this._road = new Road_1.Road();
        this.addChild(road);
        road.setup();
        var pierWidth = this._road.getFristPier();
        var player = this._player = new Player_1.Player();
        this.addChild(player);
        player.initPlayer(pierWidth);
        var strut = this._strut = new Strut_1.Strut();
        this.addChild(strut);
        strut.init();
        this._scoreContainer = new engine.Container();
        this.addChild(this._scoreContainer);
        this.initLabScore();
    };
    GameView.prototype.start = function (guide) {
        return __awaiter(this, void 0, void 0, function () {
            var initScore;
            return __generator(this, function (_a) {
                this._isTouchLayer = true;
                this._sumScore = 0;
                this._isMouseDown = false;
                this._guide = guide;
                initScore = this._road.getStartGold(0) ? props_1.props.goldScore : 0;
                this.updateScore(initScore);
                if (this._guide == '1') {
                    this.setGuide();
                }
                else {
                    this.initTouch();
                    this.registerEvent();
                }
                return [2];
            });
        });
    };
    GameView.prototype.setGuide = function () {
        var _this = this;
        this._road.setGuide();
        var guideLayer = this.guideLayer = new GuideLayer_1.GuideLayer();
        this.addChild(guideLayer);
        this.guideLayer.show(1, { x: 20, y: 650, guideText: props_1.props.guideText1 }, function () {
            var posX = _this._road.getMovePos();
            _this.guideLayer.show(2, { x: posX + 20, y: 620, guideText: props_1.props.guideText2 }, function () {
                _this.initTouch();
                _this.registerEvent();
            });
        });
    };
    GameView.prototype.initLabScore = function () {
        var scoreBg = new engine.Sprite(utils_1.getTextureByName('scoreBg'));
        scoreBg.x = utils_1.getStage().width / 2 - scoreBg.width / 2;
        scoreBg.y = 80;
        var scoreHint = new engine.Sprite(utils_1.getTextureByName('scoreHint'));
        scoreHint.x = utils_1.getStage().width / 2 - scoreHint.width / 2;
        scoreHint.y = 40;
        this._scoreContainer.addChild(scoreHint);
        this.labScore = new ScoreLabel_1.ScoreLabel();
        this.labScore.fillColor = 0xff7646;
        this.labScore.size = 70;
        this.labScore.width = utils_1.getStage().width;
        this.labScore.height = scoreBg.height;
        this.labScore.textAlign = engine.TEXT_ALIGN.CENTER;
        this.labScore.x = 0;
        this.labScore.y = scoreBg.y + 10;
        this._scoreContainer.addChild(this.labScore);
    };
    GameView.prototype.registerEvent = function () {
        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    GameView.prototype.removeListener = function () {
        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    GameView.prototype.initTouch = function () {
        this._touchLayer = new engine.Rect();
        this.addChild(this._touchLayer);
        this._touchLayer.width = utils_1.getStage().width;
        this._touchLayer.height = utils_1.getStage().height;
        this._touchLayer.x = 0;
        this._touchLayer.y = 0;
        this._touchLayer.alpha = 0;
    };
    GameView.prototype.setScoreShow = function () {
    };
    GameView.prototype.onMouseDown = function () {
        if (this._isTouchLayer) {
            this._isMouseDown = true;
            this._strut.onMouseDown(this._road.getFristPier(), this._road.getDistance(), this.goCallBcak.bind(this));
        }
    };
    GameView.prototype.onMouseUp = function () {
        if (this._isTouchLayer && this._isMouseDown) {
            this._strut.onMouseUp();
            this._isMouseDown = false;
            this._isTouchLayer = false;
        }
    };
    GameView.prototype.goCallBcak = function (isSuccess) {
        var _this = this;
        if (isSuccess) {
            console.log('成功了');
            var movePos = this._road.getMovePos();
            if (this._road.getStartGold(1, false)) {
                this.updateScore(props_1.props.singleScore + props_1.props.goldScore);
            }
            else {
                this.updateScore(props_1.props.singleScore);
            }
            this._player.setViewport(movePos, this.complete.bind(this));
        }
        else {
            console.log('失败了');
            this._player.setViewport(this._strut.getStrutHeight(), function () {
                console.log('掉下去了');
                engine.globalEvent.dispatchEvent('dxbcyj-game-result', { score: _this._sumScore });
            }, this._road.getFristPier());
        }
    };
    GameView.prototype.complete = function () {
        var _this = this;
        this._road.getStartGold(1);
        var movePos = this._road.getMovePos();
        this._road.setViewport();
        this._backgroud.setViewport(movePos);
        this._player.setBackViewport(function () {
            _this._isTouchLayer = true;
        });
        this.closeStrut();
    };
    GameView.prototype.closeStrut = function () {
        this._strut.rest();
    };
    GameView.prototype.updateScore = function (score) {
        this._sumScore += score;
        if (0 <= this._sumScore && this._sumScore <= props_1.props.bgFristScore) {
            this.changeBg(0);
        }
        else if (props_1.props.bgFristScore < this._sumScore && this._sumScore <= props_1.props.bgSecondScore) {
            this.changeBg(1);
        }
        else {
            this.changeBg(2);
        }
        this.labScore.updateScore(this._sumScore);
    };
    GameView.prototype.getScore = function () {
        return this._sumScore;
    };
    GameView.prototype.changeBg = function (index) {
        if (this._backgroud.getBgIndex() != index) {
            this._backgroud.changeBg(index);
        }
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
