"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var LoopComponent_1 = require("./LoopComponent");
var props_1 = require("./../props");
var Background = (function (_super) {
    __extends(Background, _super);
    function Background() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.partResHHL = ['hhl_after', 'hhl_front'];
        _this.partResHB = ['hb_after', 'hb_front'];
        _this.partResWH = ['wh_after', 'wh_front'];
        _this.speeds = [];
        _this.resArray = [];
        _this.frameMovePos = 0;
        return _this;
    }
    Background.prototype.initBg = function () {
        this.sumMovePos = 0;
        this.speeds.push(props_1.props.afterBGMoveSpeed);
        this.speeds.push(props_1.props.frontBGMoveSpeed);
        var bottomBg = new engine.Rect();
        bottomBg.x = 0;
        bottomBg.y = 0;
        bottomBg.width = utils_1.getStage().width;
        bottomBg.height = 0;
        bottomBg.fillColor = 0x75c9f5;
        this.addChild(bottomBg);
        this.resArray.push(this.partResHHL);
        this.resArray.push(this.partResHB);
        this.resArray.push(this.partResWH);
        this._bgIndex = 0;
        var parts = [];
        for (var i = 0; i < 2; i++) {
            var part = new LoopComponent_1.LoopComponent();
            part.setupLoop([
                this.resArray[0][i],
                this.resArray[0][i],
            ]);
            parts.push(part);
            this.addChild(part);
        }
        parts[1].y = 200;
    };
    Background.prototype.setViewport = function (pos) {
        this.needFrameSum = (props_1.props.pierMoveTime / 1000) * 60;
        this.frameMovePos = pos / this.needFrameSum;
        this.frameIndex = 0;
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameBack, this);
    };
    Background.prototype.frameBack = function () {
        if (this.frameIndex < this.needFrameSum) {
            for (var i = 0; i < 2; i++) {
                var part = this.getChildAt(i + 1);
                var speed = this.speeds[i];
                var tmpPos = ((this.frameMovePos * this.frameIndex) + this.sumMovePos) * speed;
                part.setViewport(tmpPos);
            }
            this.frameIndex++;
        }
        else {
            this.sumMovePos += this.frameMovePos * this.needFrameSum;
            this.frameIndex = 0;
            this.removeEventListener(engine.Event.ENTER_FRAME, this.frameBack, this);
        }
    };
    Background.prototype.changeBg = function (index) {
        for (var i = 0; i < 2; i++) {
            var part = this.getChildAt(i + 1);
            part.changeBg(this.resArray[index][i]);
            if (i == 1 && index == 1) {
                part.y = 400;
            }
            if (i == 1 && index == 2) {
                part.y = 250;
            }
        }
        this._bgIndex = index;
    };
    Background.prototype.getBgIndex = function () {
        return this._bgIndex;
    };
    return Background;
}(engine.Container));
exports.Background = Background;
