"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var FrontBoxs = (function (_super) {
    __extends(FrontBoxs, _super);
    function FrontBoxs() {
        var _this = _super.call(this) || this;
        _this.frontBoxs = [];
        return _this;
    }
    FrontBoxs.prototype.setup = function () {
        var initX, initY = 0;
        for (var i = 0; i < props_1.props.dollNum; i++) {
            if (!new engine.Sprite(utils_1.getTextureByName('frontbox_' + i))) {
                return;
            }
            this.frontBoxs[i] = new engine.Sprite(utils_1.getTextureByName('frontbox_' + i));
            initX = this.frontBoxs[0].x = props_1.props.frontInitX;
            initY = this.frontBoxs[0].y = props_1.props.frontInitY;
            this.frontBoxs[i]['npcType'] = 'box' + i;
        }
        this.frontBoxs[props_1.props.dollNum] = new engine.Sprite(utils_1.getTextureByName('frontbox_0'));
        this.frontBoxs[props_1.props.dollNum]['npcType'] = 'box' + props_1.props.dollNum;
        console.log(this.frontBoxs);
        for (var i = 0; i < this.frontBoxs.length; i++) {
            if (i == 0) {
                this.frontBoxs[i].x = initX;
            }
            else {
                this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.frontBoxs[0].width - props_1.props.frontmargin;
            }
            console.log(this.frontBoxs[i].x);
            this.frontBoxs[i].y = initY;
            this.addChild(this.frontBoxs[i]);
            console.log('aaa', this.frontBoxs[i].x);
        }
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
    };
    FrontBoxs.prototype.frameMove = function () {
        var _this = this;
        this.frontBoxs.forEach(function (item, index) {
            item.x += props_1.props.moveSpeed;
            if (item.x <= 0 && !item.visible) {
                item.visible = true;
            }
            if (item.x >= 750) {
                var tmpIndex = 0;
                if (index <= 0) {
                    tmpIndex = _this.frontBoxs.length - 1;
                }
                else {
                    tmpIndex = index - 1;
                }
                item.x = _this.frontBoxs[tmpIndex].x - _this.frontBoxs[0].width - props_1.props.frontmargin;
                if (!_this.GameView.getMoveX() && item.x <= 0 && _this.GameView.startstatus) {
                    _this.GameView.setMoveX((370 - item.x - 13) / props_1.props.moveSpeed, item);
                    _this.hideBox = item;
                }
            }
        });
    };
    FrontBoxs.prototype.stop = function () {
    };
    FrontBoxs.prototype.showHidePrizeBox = function (isshow) {
        this.hideBox.visible = isshow;
    };
    return FrontBoxs;
}(engine.Container));
exports.FrontBoxs = FrontBoxs;
