"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var BackBoxs = (function (_super) {
    __extends(BackBoxs, _super);
    function BackBoxs() {
        var _this = _super.call(this) || this;
        _this.backBoxs = [];
        return _this;
    }
    BackBoxs.prototype.setup = function () {
        var initX, initY = 0;
        for (var i = 0; i < props_1.props.dollNum; i++) {
            this.backBoxs[i] = new engine.Sprite(utils_1.getTextureByName('backbox_' + i));
            initX = this.backBoxs[0].x = props_1.props.backInitX;
            initY = this.backBoxs[0].y = props_1.props.backInitY - props_1.props.initOffsetTop;
            this.backBoxs[i]['npcType'] = 'box' + i;
        }
        this.backBoxs[props_1.props.dollNum] = new engine.Sprite(utils_1.getTextureByName('backbox_0'));
        this.backBoxs[props_1.props.dollNum]['npcType'] = 'box' + props_1.props.dollNum;
        for (var i = 0; i < this.backBoxs.length; i++) {
            if (i == 0) {
                this.backBoxs[i].x = initX;
            }
            else {
                this.backBoxs[i].x = this.backBoxs[i - 1].x + this.backBoxs[i].width + props_1.props.backmargin;
            }
            this.backBoxs[i].y = initY;
            this.addChild(this.backBoxs[i]);
        }
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
    };
    BackBoxs.prototype.frameMove = function () {
        var _this = this;
        this.backBoxs.forEach(function (item) {
            item.x -= props_1.props.moveSpeed;
            if (item.x <= 0) {
                var lastitem = _this.backBoxs.shift();
                lastitem.x = _this.backBoxs[_this.backBoxs.length - 1].x + item.width + props_1.props.backmargin;
                _this.backBoxs.push(lastitem);
            }
        });
    };
    return BackBoxs;
}(engine.Container));
exports.BackBoxs = BackBoxs;
