"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var frontBox_1 = require("./frontBox");
var backBox_1 = require("./backBox");
var Zhuazi_1 = require("./Zhuazi");
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.startstatus = false;
        _this.ifPrize = false;
        _this.goodsItems = [];
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        var _this = this;
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        var frontBoxs = (this._frontBoxs = new frontBox_1.FrontBoxs());
        this._frontBoxs.GameView = this;
        var backBoxs = (this._backBoxs = new backBox_1.BackBoxs());
        this._Zhuazi = new Zhuazi_1.Zhuazi();
        this._Zhuazi.GameView = this;
        this.frontTransfer = new engine.Container();
        this.backTransfer = new engine.Container();
        this.frontTransfer.width = 0;
        this.frontTransfer.height = 0;
        this.frontTransfer.alpha = 1;
        this.backTransfer.width = 0;
        this.backTransfer.height = 0;
        this.backTransfer.alpha = 1;
        this.rect = new engine.Rect();
        this.rect.width = props_1.props.gameStageWidth;
        this.rect.height = props_1.props.gameStageHeight;
        this.rect.x = 65;
        this.rect.y = 0;
        this.NpcBg = new engine.Container();
        this.NpcBg.x = 0;
        this.NpcBg.y = 0;
        this.addChild(this.NpcBg);
        this.addChild(this.rect);
        this.frontDesk = new engine.Sprite(utils_1.getTextureByName("前传输带"));
        this.frontDesk.x = props_1.props.initOffsetLeft;
        this.frontDesk.y = props_1.props.frontDeskY - props_1.props.initOffsetTop;
        this.backDesk = new engine.Sprite(utils_1.getTextureByName("后传输带"));
        this.backDesk.x = props_1.props.initOffsetLeft;
        this.backDesk.y = props_1.props.backDeskY - props_1.props.initOffsetTop;
        if (props_1.props.single) {
            this.backDesk.visible = false;
        }
        var pcarr = [this.backDesk, this.frontDesk, this.backTransfer, this.frontTransfer, this._Zhuazi];
        pcarr.forEach(function (item) {
            _this.NpcBg.addChild(item);
        });
        this.NpcBg.mask = this.rect;
        this._Zhuazi.setup();
        this.backTransfer.addChild(this._backBoxs);
        this._backBoxs.setup();
        if (props_1.props.single) {
            this.backTransfer.visible = false;
        }
        this.frontTransfer.addChild(this._frontBoxs);
        this._frontBoxs.setup();
    };
    GameView.prototype.stopMove = function () {
        this._frontBoxs.stop();
    };
    GameView.prototype.setMoveX = function (x, item) {
        this.moveTime = x;
        this.prizeBox = item;
        this._Zhuazi.move();
    };
    GameView.prototype.setVisible = function (isshow) {
        this._frontBoxs.showHidePrizeBox(isshow);
    };
    GameView.prototype.getMoveX = function () {
        return this.moveTime;
    };
    GameView.prototype.resetMoveX = function () {
        this.moveTime = null;
    };
    GameView.prototype.getBox = function () {
        return this.prizeBox;
    };
    GameView.prototype.reset = function () {
        this.startstatus = false;
        this.ifPrize = false;
        this._Zhuazi.getReset();
    };
    GameView.prototype.start = function (type) {
        if (type === void 0) { type = null; }
        this.speed = 1;
        this.gameIng = true;
        console.log('执行', type);
        this.startstatus = true;
        this.ifPrize = type && type.prize || false;
    };
    GameView.prototype.beginNpc = function () {
        var _this = this;
        this.timer = setTimeout(function () {
            if (_this.gameIng) {
            }
        }, 2000 / this.speed);
    };
    GameView.prototype.pause = function () {
        this.gameIng = false;
    };
    GameView.prototype.revive = function () {
        this.gameIng = true;
    };
    GameView.prototype.resume = function () {
        this.reset();
        this.start();
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
