"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ObjectPool = engine.ObjectPool;
var utils_1 = require("./utils");
var object_pool_init_1 = require("./object-pool-init");
var frontBox_1 = require("./frontBox");
var backBox_1 = require("./backBox");
var Zhuazi_1 = require("./Zhuazi");
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.startstatus = false;
        _this.ifPrize = false;
        _this.goodsItems = [];
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        var frontBoxs = (this._frontBoxs = new frontBox_1.FrontBoxs());
        this._frontBoxs.GameView = this;
        var backBoxs = (this._backBoxs = new backBox_1.BackBoxs());
        this._Zhuazi = new Zhuazi_1.Zhuazi();
        this._Zhuazi.GameView = this;
        this.frontTransfer = new engine.Container();
        this.backTransfer = new engine.Container();
        this.frontTransfer.width = 0;
        this.frontTransfer.height = 0;
        this.frontTransfer.alpha = 1;
        this.backTransfer.width = 0;
        this.backTransfer.height = 0;
        this.backTransfer.alpha = 1;
        this.rect = new engine.Rect();
        this.rect.width = 611;
        this.rect.height = 704;
        this.rect.x = 65;
        this.rect.y = 263;
        this.NpcBg = new engine.Container();
        this.addChild(this.NpcBg);
        this.addChild(this.rect);
        var gameBg = new engine.Sprite(utils_1.getTextureByName("游戏背景"));
        gameBg.x = 65;
        gameBg.y = 263;
        this.NpcBg.addChild(gameBg);
        this.frontDesk = new engine.Sprite(utils_1.getTextureByName("前传输带"));
        this.frontDesk.x = 60;
        this.frontDesk.y = 781;
        this.backDesk = new engine.Sprite(utils_1.getTextureByName("后传输带"));
        this.backDesk.x = 60;
        this.backDesk.y = 712;
        this.NpcBg.addChild(this.backDesk);
        this.NpcBg.addChild(this.frontDesk);
        this.NpcBg.addChild(this.backTransfer);
        this.NpcBg.addChild(this.frontTransfer);
        this.NpcBg.addChild(this._Zhuazi);
        this.NpcBg.mask = this.rect;
        this._Zhuazi.setup();
        this.backTransfer.addChild(this._backBoxs);
        this._backBoxs.setup();
        this.frontTransfer.addChild(this._frontBoxs);
        this._frontBoxs.setup();
    };
    GameView.prototype.stopMove = function () {
        this._frontBoxs.stop();
    };
    GameView.prototype.setMoveX = function (x, item) {
        this.moveTime = x;
        this.prizeBox = item;
        this._Zhuazi.move();
    };
    GameView.prototype.setVisible = function (isshow) {
        this._frontBoxs.showHidePrizeBox(isshow);
    };
    GameView.prototype.getMoveX = function () {
        return this.moveTime;
    };
    GameView.prototype.resetMoveX = function () {
        this.moveTime = null;
    };
    GameView.prototype.getBox = function () {
        return this.prizeBox;
    };
    GameView.prototype.reset = function () {
        this.startstatus = false;
        this.ifPrize = false;
        this._Zhuazi.getReset();
    };
    GameView.prototype.start = function (type) {
        if (type === void 0) { type = null; }
        this.speed = 1;
        this.gameIng = true;
        console.log('执行', type);
        this.startstatus = true;
        this.ifPrize = type && type.prize || false;
    };
    GameView.prototype.beginNpc = function () {
        var _this = this;
        this.timer = setTimeout(function () {
            if (_this.gameIng) {
            }
        }, 2000 / this.speed);
    };
    GameView.prototype.pause = function () {
        this.gameIng = false;
    };
    GameView.prototype.revive = function () {
        this.gameIng = true;
    };
    GameView.prototype.resume = function () {
        this.reset();
        this.start();
    };
    GameView.prototype.initNpc = function () {
        this.box1 = new engine.Sprite(utils_1.getTextureByName("草泥马盒"));
        this.box2 = new engine.Sprite(utils_1.getTextureByName("狗盒"));
        this.box3 = new engine.Sprite(utils_1.getTextureByName("猫盒"));
        this.box4 = new engine.Sprite(utils_1.getTextureByName("草泥马盒"));
        this.box5 = new engine.Sprite(utils_1.getTextureByName("猫盒"));
        this.box1.x = 120;
        this.box1.y = 434;
        this.box2.x = 306;
        this.box2.y = 434;
        this.box3.x = 487;
        this.box3.y = 434;
        this.box4.x = 240;
        this.box4.scaleX = 0.5;
        this.box4.scaleY = 0.5;
        this.box4.y = 390;
        this.box5.x = 434;
        this.box5.y = 390;
        this.box5.scaleX = 0.5;
        this.box5.scaleY = 0.5;
        this.backTransfer.addChild(this.box4);
        this.backTransfer.addChild(this.box5);
        this.frontTransfer.addChild(this.box1);
        this.frontTransfer.addChild(this.box2);
        this.frontTransfer.addChild(this.box3);
    };
    GameView.prototype.died = function () {
        this.score = 0;
        this.pause();
    };
    GameView.prototype.removeNpc = function (goods) {
        this.NpcBg.removeChild(goods);
        ObjectPool.recycleObject(object_pool_init_1.PoolName, goods);
        goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
        var index = this.goodsItems.indexOf(goods);
        if (index > -1) {
            this.goodsItems.splice(index, 1);
        }
    };
    GameView.prototype.recycleGoods = function () {
        clearTimeout(this.timer);
        clearInterval(this.countdownTimer);
        for (var _i = 0, _a = this.goodsItems; _i < _a.length; _i++) {
            var goods = _a[_i];
            if (goods) {
                this.removeChild(goods);
                ObjectPool.recycleObject(object_pool_init_1.PoolName, goods);
                goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
            }
        }
        this.goodsItems = [];
    };
    GameView.prototype.hasHit = function (a, b) {
        if (Math.abs(a.x + a.width / 2 - (b.x + b.width / 2)) <
            a.width / 2 + b.width / 2 &&
            Math.abs(a.y + a.height / 2 - (b.y + b.height / 2)) <
                a.height / 2 + b.height / 2) {
            return true;
        }
        else {
            return false;
        }
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
