'use strict';

import React, { Component } from 'react';
import Comdownpop from '../../components/comdownpop/comdownpop';
import Comleftpop from '../../components/comleftpop/comleftpop';
import Comuppop from '../../components/comuppop/comuppop';
import EdPop from '../../EdPop/EdPopRedux/EdPop';
import EdPopAnimType from '../../EdPop/EdPopRedux/style/EdPopAnimType';
import resList from '../../resconfig/resList';
//import API from '../../api';

import './pagetest.less';
class Pagetest extends Component {
    constructor(props) {
        super(props);
        this.state = { resList: resList };
    }

    /**弹出一个顶部弹窗 */
    showUpPop = () => {
        EdPop.showPop(Comuppop, { animType: EdPopAnimType.FLY_DOWN })
    }

    /**弹出一个左侧弹窗 */
    showLeftPop = () => {
        EdPop.showPop(Comleftpop,{animType:EdPopAnimType.FLY_RIGHT});
    }

    /**弹出一个右侧弹窗 */
    showRightPop = () => {

    }

    /**弹出一个底部弹窗 */
    showDownPop = () => {
        EdPop.showPop(Comdownpop,{animType:EdPopAnimType.FLY_UP})
    }

    /**弹出一个中间弹窗 */
    showCenterPop=()=>{
        EdPop.showPop()
    }

    render() { 
        return (
            <div className="test ">
                <button className="testbtn test_popup " onClick={this.showUpPop}>弹出一个顶部弹窗</button>
                <button className="testbtn test_downpop" onClick={this.showDownPop}>弹出一个底部弹窗</button>
                <button className="testbtn test_leftpop" onClick={this.showLeftPop}>弹出一个左侧弹窗</button>
                <button className="testbtn test_rightpop" onClick={this.showCenterPop}>弹出一个右侧弹窗</button>
                <button className="testbtn test_centerpop">弹出一个中间弹窗</button>
                <button className="testbtn test_changesinglemode">设置为单一弹窗模式</button>
                <button className="testbtn test_changenormalmode">设置为正常模式</button>
            </div>
        );
    }
}
export default Pagetest;
