import { Ins } from "../../Ins";
import { BaseEnemy, enemyType } from "./BaseEnemy";

export class PurpleElite extends BaseEnemy{
    constructor(){
        super();
    }
    canShot = true;
    
    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("1fa033a7-ca94-4071-a627-170166a9bcde");
        that.hitW = 158;
        that.hitH = 100;
        that.health = 30;
        that.speedVector.y = 1;  
        that.speedY = 3;
        that.y = -80;
        that.x = Math.floor(Math.random()*Ins.stageW*2/4+Ins.stageW/4);
        that.enemyType = enemyType.elite;
    }

    updateSelf(){
        var that = this;
        super.updateSelf();
        if(that.y >= Ins.stageH/2){
                if(this.canShot){
                    this.canShot = false
                    that.createAGrapeShot();
                }
        }
    }
}