import { BaseEnemyBullet } from "./BaseEnemyBullet";
import { EffectAnim } from "../EffectAnim";
import { rectCollsion } from "../utils";
import { GameManager } from "../Manager/GameManager";
import { EffectManager } from "../Manager/EffectManager";
import { LayerManager } from "../Manager/LayerManager";
import { BaseEnemy, enemyState } from "./BaseEnemy";

export class Laser extends BaseEnemyBullet{
    headImg:EffectAnim;
    laserAwake:boolean = false;
    call:Function;
    args:any;
    enemy:BaseEnemy;
    type:number
    offset:number;
    constructor(enemy:BaseEnemy,x:number,y:number,call:Function,args:any,type1:number){
        super();
        this.enemy = enemy;
        this.offset = x;
        this.y = y;
        this.call = call;
        this.args = args;
        this.type = type1;
    }

    addToViewPort(){
        super.addToViewPort();
        this.setBodyImg("2f4bf605-bcdc-43be-81d8-3181d3af2217");
        this.bodyImg.anchorX = this.bodyImg.width*0.5;
        this.bodyImg.x = -this.bodyImg.width*0.5;
        this.bodyImg.scaleY = 0;
        EffectManager.Ins.createEffect(this,"laserHead",15,4,0,0,null,null,true)
    }

    updateSelf(){
        var that = this;
        if(that.bodyImg.scaleY<1){
            that.bodyImg.scaleY+=0.05;
        }else {
            this.worldTime ++;
            if(this.worldTime%60 == 0){
                if(that.args&&that.call){
                    that.call.call(that.args);
                    that.call = that.args = null;
                }
                this.removeSelf();
                return;
            }
            that.bodyImg.scaleY = 1;
        }
        if(that.enemy&&!that.enemy.isDead){
            if(that.type==0){
                that.x = that.offset?that.enemy.getCenterP().x-that.offset:that.enemy.getCenterP().x-80;
            }else{
                that.x = that.offset?that.enemy.getCenterP().x+that.offset:that.enemy.getCenterP().x+80;
            }
            
        }
        var player = GameManager.INS.playerPlane;
        var x1 = player.getCenterP().x;
        var y1 = player.getCenterP().y;
        var pos = this.localToGlobal(new FYGE.Point(0,this.bodyImg.height*0.5))
        var x2 = pos.x;
        var y2 = pos.y;
        var w1 = player.hitW;
        var h1 = player.hitH;
        var w2 = this.bodyImg.width;
        var h2 = this.bodyImg.height;
        if(rectCollsion(x1,y1,x2,y2,w1,h1,w2,h2)){
            player.hitDamage(1);
        }
    }
}