import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";
import { EffectAnim } from "../EffectAnim";
import { EffectManager } from "../Manager/EffectManager";
import { Ins } from "../../Ins";

export class GreenBoss extends BaseEnemy{
    canDash:boolean = true;
    constructor(){
        super();
    }

    addToViewPort(){
        super.addToViewPort();
        this.setBody("349bcce8-ac94-4f72-96bb-f0a27de90a11");
        this.x = Ins.stageW*0.5-this.bodyImg.width*0.5;
        this.y = -this.bodyImg.height;
        this.hitW = 250;
        this.hitH = 120;
        this.health = 600;
        this.enemyType = enemyType.boss;
        this.changeState(enemyState.goStage);
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=that.bodyImg.height*0.4){
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                that.horizonBounds();
                if(that.worldTime%90 == 0){
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.attack:
                that.horizonBounds();
                switch(that.curSkillIndex){
                    case 0:
                        that.createDartBullet();
                        break;
                    case 1:
                        that.dashAttack();
                        break;
                }
                break;
        }
    }

    lastSpeedX:number = 1;
    dashEffect:EffectAnim;
    dashAttack(){
        var that = this;
        if(!that.canDash) return;
        that.canDash = false;
        that.lastSpeedX = that.speedVector.x;
        that.speedVector.x = 0;
        that.dashEffect = EffectManager.Ins.createEffect(this,"DashFire",50,3,this.bodyImg.width>>1,0,null,null,true);
        FYGE.Tween.get(this).to({y:Ins.stageH},1000,FYGE.Ease.quintIn).call(()=>{
            if(that&&!that.isDead){
                that.dashEffect.removeEffect();
                that.y = -that.bodyImg.height;
                that.canDash = true;
                that.changeState(enemyState.goStage);
            }
        },this)
    }

    changeState(state:enemyState){
        var that = this;
        switch(state){
            case enemyState.goStage:
                that.speedX = 0;
                that.speedY = 2;
                that.speedVector.y = 1;
                that.speedVector.x = 0;
                break;
            case enemyState.inSatge:
                that.speedY = 0;
                that.speedX = 1;
                that.worldTime = 0;
                if(that.speedVector.x == 0)
                    that.speedVector.x = that.lastSpeedX;
                that.speedVector.y = 0;
                break;
            case enemyState.attack:
                that.attackState();
                break;
        }
        that.enemyState = state;
    }
     
    removeFromViewPort(){
        super.removeFromViewPort();
    }
}