import { EffectManager } from "../Manager/EffectManager";
import { LayerManager } from "../Manager/LayerManager";
import { getTexture, vectorUnit, rectCollsion } from "../utils";
import { BaseSprite } from "../BaseSprite";
import { GameManager } from "../Manager/GameManager";
import { EnemyBulletManager } from "../Manager/EnemyBulletManager";
import { buffType } from "../Buff/Buff";
import { Ins } from "../../Ins";
import { EnemyManager } from "../Manager/EnemyManager";

export enum enemyState{
    default,
    goStage,
    inSatge,
    wait,
    dash,
    attack
}
export enum enemyType{
    default,
    boss,
    elite,
    normal
}
export class BaseEnemy extends BaseSprite{
    worldTime:number = 0;
    damage:number = 0;
    speedX:number = 0;
    speedY:number = 0;
    speedVector:FYGE.Point;
    bodyImg:FYGE.Sprite;
    hitW:number = 0;
    hitH:number = 0;
    enemyState:enemyState = enemyState.default;
    enemyType:enemyType = enemyType.default;
    isInvincible:boolean = false;   //无敌
    damageEffecting:boolean = false;
    health:number = 0;
    isDead:boolean = false;

    lastSkillIndex = 0;
    curSkillIndex = -1;
    curSkillMax:number = 1;

    dartBulletVector1:FYGE.Point = null;
    dartBulletVector2:FYGE.Point = null;
    dartBulletCount = 0;
    dartBulletMax = 4;
    dartBulletTime:number = 0;

    volatilizationCount:number = 0;
    volatilizationMax:number = 5;
    volatilizationTime:number = 9;
    volatilizationEffect:boolean = false;

    canCreateLaser:boolean = true;

    groupShotCnt:number = 0;
    groupShotMax:number = 3;
    groupShotTime:number = 9;
    groupShotEffect:boolean = false;

    spiralTime:number = 2;
    spiralRotate:number = 0;
    spiralCnt:number = 0;
    spiralMax:number = 24;

    swordGrapShotCnt:number = 0;
    swordGrapShotMax:number = 3;
    swordGrapShotTime:number = 9;

    /**三组瞄准子弹系数 */
    swordAimShotCnt:number = 0;
    swordAimShotMax:number = 3;
    swordAimShotTime:number = 9;

    constructor() {
        super();
    }

    addToViewPort(){
        super.addToViewPort();
        var that = this;
        this.speedVector = new FYGE.Point();
        that.bodyImg = new FYGE.Sprite();
        that.addChild(that.bodyImg);
    }

    updateSelf(){
        var that = this;
        that.x += that.speedX*that.speedVector.x;
        that.y += that.speedY*that.speedVector.y;
        that.playerCollsion();
        if(that.y>Ins.stageH){
            that.removeEnemy();
            return;
        }
    }

    damageHit(value:number){
        if(this.isInvincible||this.isDead) return;
        var that = this;
        if(!that.damageEffecting){
            that.damageEffecting = true;
            EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"hit",26,4,that.x+that.bodyImg.width*0.5,that.y+that.bodyImg.height*0.5,()=>{
                if(that&&that.parent)
                that.damageEffecting = false},that);
        }
        that.health -= value;
        if(that.health<=0){
            that.visible = false;
            that.isDead = true;
            that.dead();
        }
    }

    dead(){
        var that = this;
        let score = 0;
        switch(that.enemyType){
            case enemyType.normal:
                score = Ins.enemyScore.normalEnemy;
                EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"eboom",36,7,that.getCenterP().x,that.getCenterP().y);
                break;
            case enemyType.elite:
                score = Ins.enemyScore.eliteEnemy;
                EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"eboom",36,7,that.getCenterP().x,that.getCenterP().y);
                break;
            case enemyType.boss:
                score = Ins.enemyScore.bossEnemy;
                EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"boom",40,4,that.getCenterP().x,that.getCenterP().y);
                GameManager.INS.createBuff(LayerManager.Ins.buffLayer,that.getCenterP().x,that.getCenterP().y,buffType.fireLevel);
                break;
            default:console.log("敌人类型没有设置，为default");
        }
        GameManager.INS.addScore(score)
        this.removeEnemy();
    }

    removeEnemy(){
        if(this.enemyType===1)
            FYGE.GDispatcher.dispatchEvent("bossDead");
        // window["EnemyManager"].enemyArrRemove(this);
        EnemyManager.Ins.enemyArrRemove(this);
        // FYGE.GDispatcher.dispatchEvent("enemyRemove",this);
    }

    changeState(state:enemyState){
        
    }


    /**发射Dart子弹 */
    createDartBullet(){
        var that = this;
        that.dartBulletTime++;
        if(that.dartBulletTime%6==0){
            that.dartBulletTime = 0;
            for(var i=0;i<2;i++){
                if(!that.dartBulletVector1||!that.dartBulletVector2){ 
                    that.dartBulletVector1 = vectorUnit(GameManager.INS.playerPlane.getCenterP().x - (that.getCenterP().x-80),GameManager.INS.playerPlane.getCenterP().y-that.getCenterP().y);
                    that.dartBulletVector2 = vectorUnit(GameManager.INS.playerPlane.getCenterP().x - (that.getCenterP().x+160),GameManager.INS.playerPlane.getCenterP().y-that.getCenterP().y);
                }
                var vector = that.dartBulletVector1;
                if(i%2!=0)
                    vector = that.dartBulletVector2;
                EnemyBulletManager.Ins.createBullet(null,LayerManager.Ins.bulletLayer,that.getCenterP().x-80+i*160,that.y+that.bodyImg.height,1,10,vector);
            }
            that.dartBulletCount++;
            if(that.dartBulletCount>=that.dartBulletMax){
                that.dartBulletCount = 0;
                that.dartBulletVector1 = null;
                that.dartBulletVector2 = null;
                that.changeState(enemyState.inSatge);
            }
        }
    }

    /**发射镭射 */
    createLaser(offset?:number){
        if(!this.canCreateLaser) return;
        var that = this;
        that.canCreateLaser = false;
        let x1 = offset?that.bodyImg.width*0.5-offset:that.bodyImg.width*0.5-80;
        let x2 = offset?that.bodyImg.width*0.5+offset:that.bodyImg.width*0.5+80;
        EffectManager.Ins.createEffect(that,"polymerization",56,5,x1,that.bodyImg.height,()=>{
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,offset,that.y+that.bodyImg.height-10,2,null,null,0,null,()=>{
                if(that&&that.parent){
                    that.canCreateLaser = true;
                    that.changeState(enemyState.inSatge)
                }
            },that)
        },that,true,2)
        EffectManager.Ins.createEffect(that,"polymerization",56,5,x2,that.bodyImg.height,()=>{
                EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,offset,that.y+that.bodyImg.height-10,2,null,null,1,null,()=>{
                    if(that&&that.parent){
                        that.canCreateLaser = true;
                        that.changeState(enemyState.inSatge)
                    }
                },that)
        },that,true,2);
        
    }

    /**创建发射子弹 */
    createVolatilization(){
        var  that = this;
        if(!that.volatilizationEffect){
            that.volatilizationEffect = true;
            for(var i=0;i<3;i++){
                let x = that.getCenterP().x-60+i*60;
                let y = that.getCenterP().y+60-(i%2)*120;
                    EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"polymerization",44,5,x,y,null,null,true,4);
            }
            that.volatilizationTime = 9;
        }
        that.volatilizationTime++;
        if(that.volatilizationTime%10==0){
            that.volatilizationTime = 0;
            var player = GameManager.INS.playerPlane;
            for(var i=0;i<3;i++){
                let x = that.getCenterP().x-60+i*60;
                let y = that.getCenterP().y+60-(i%2)*120;
                let targetX = player.getCenterP().x + Math.floor(Math.random()*10-5)
                let targetY = player.getCenterP().y + Math.floor(Math.random()*10-5)
                var vector = vectorUnit(targetX-x,targetY-y);
                EnemyBulletManager.Ins.createBullet(null,LayerManager.Ins.bulletLayer,x,y,3,14,vector,1);
            }
            that.volatilizationCount++;
            if(that.volatilizationCount>=that.volatilizationMax){
                that.volatilizationEffect = false;
                that.volatilizationCount = 0;
                that.volatilizationTime = 9;
                that.changeState(enemyState.inSatge);
            }
        }
    }

    /**创建分裂弹 */
    createSplitBullet(){
        var that = this;
        var randomX = Math.floor(Math.random()*(Ins.stageW-160)+80);
        var randomY = Math.floor(Math.random()*(Ins.stageH/3)+Ins.stageH/3);
        for(var i=0;i<2;i++){
            var x = that.getCenterP().x - 40+i*80;
            var y = that.y+that.bodyImg.height;
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,3,8,null,2,new FYGE.Point(randomX+i*80,randomY))
        }
        that.changeState(enemyState.inSatge);
    }

    /**创建三行散弹 */
    createGrapeshot(offset?:number){
        var that = this;
        if(!that.groupShotEffect){
            that.groupShotEffect = true;
            for(var i=0;i<2;i++){
                let x = that.bodyImg.width*0.5 - 60+i*120;
                EffectManager.Ins.createEffect(that,"polymerization",50,5,x,that.bodyImg.height+40,null,null,true,3);
            }
            that.groupShotTime = 9;
        }
        that.groupShotTime++;
        if(that.groupShotTime%10==0){
            that.groupShotTime = 0;
            that.groupShotCnt ++;
            for(var i=0;i<6;i++){
                // if(i!=3){
                    var x = that.getCenterP().x - 100 + i*40;
                    var x1 = that.getCenterP().x - 125 + i*50;
                    var y = that.getCenterP().y+that.bodyImg.height*0.5;
                    var vector = vectorUnit(x1-x,40);
                    EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,3,10,vector)
                // }
            }
            if(that.groupShotCnt>=that.groupShotMax){
                that.groupShotCnt = 0;
                that.groupShotEffect = false;
                that.changeState(enemyState.inSatge);
            }
        }
    }   

    /**发射一行散弹 */
    createAGrapeShot(){
        var that = this;
        for(var i=0;i<2;i++){
            let x = that.bodyImg.width*0.5 - 60+i*120;
            EffectManager.Ins.createEffect(that,"polymerization",50,5,x,that.bodyImg.height+40);
        }
        for(var i=0;i<6;i++){
        // if(i!=3){
            var x = that.getCenterP().x - 100 + i*40;
            var x1 = that.getCenterP().x - 125 + i*50;
            var y = that.getCenterP().y+that.bodyImg.height*0.5;
            var vector = vectorUnit(x1-x,40);
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,3,10,vector)
        // }
        }
    }

    /**发射两个剑子弹 */
    createTwoSword(offset?:number){
        var that = this;
        let y = that.y+that.bodyImg.height;
        for(let i=0;i<2;i++){
            let x = offset?that.getCenterP().x-offset+i*2*offset:that.getCenterP().x-20+i*2*20;
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,4,8,new FYGE.Point(0,1));
        }
    }

    /**创建三组瞄准剑子弹 */
    createThreeGroupSword(offset?:number){
        var that = this;
        that.swordAimShotTime++;
        if(that.swordAimShotTime%10 == 0){
            that.swordAimShotTime = 0;
            that.swordAimShotCnt ++ ;
            for(let i=0;i<2;i++){
                let x = offset?that.getCenterP().x-offset+i*2*offset:that.getCenterP().x-20+i*2*20;
                let y = that.y+that.bodyImg.height;
                let player = GameManager.INS.playerPlane;
                let x1 = player.getCenterP().x;
                let y1 = player.getCenterP().y;
                let vector = vectorUnit(x1-x,y1-y);
                EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,4,8,vector);
            }
            if(that.swordAimShotCnt>=that.swordAimShotMax){
                that.swordAimShotTime = 9;
                that.swordAimShotCnt = 0;
                that.changeState(enemyState.inSatge);
            }
        }
    }



    /**发射三个剑子弹 */
    creareThreeSword(offset?:number){
        var that = this; 
        for(let i=0;i<3;i++){
            let originX:number = offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x - 30 + i*30;
            let targetX:number = offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x - 60 + i*60;
            let originY:number = that.y+that.bodyImg.height;
            let targetY:number = that.y+that.bodyImg.height+60;
            let vector:FYGE.Point = vectorUnit((targetX - originX),(targetY - originY));
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,originX,originY,4,8,vector);
        }
    }

    /**发射三行三个剑子弹 */
    createGrapThreeSword(offset?:number){
        var that = this;
        that.swordGrapShotTime++;
        if(that.swordGrapShotTime%10==0){
            that.swordGrapShotTime = 0;
            that.swordGrapShotCnt ++;
            that.creareThreeSword(offset);
            if(that.swordGrapShotCnt>=that.swordGrapShotMax){
                that.swordGrapShotTime = 9;
                that.swordGrapShotCnt = 0;
                that.changeState(enemyState.inSatge);
            }
        }
    }

    /**创建螺旋发射弹 */
    createSpiralShot(){
        var that = this;
        that.spiralTime++;
        if(that.spiralTime%5==0){
            that.spiralTime = 0;
            let angleUnit = 360/that.spiralMax;
            let angle = that.spiralCnt * angleUnit;
            var randus = Math.PI/180*angle;
            var x = that.getCenterP().x;
            var y = that.getCenterP().y;
            var vector = new FYGE.Point(Math.cos(randus),Math.sin(randus));
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,x,y,1,5,vector);
            // that.spiralRotate+=5;
            that.spiralCnt++;
            if(that.spiralCnt>=that.spiralMax){
                that.spiralRotate = 0;
                that.spiralCnt = 0;
                that.spiralTime = 4;
                that.changeState(enemyState.inSatge)
            }
        }
    }

    /**创建四方子弹 */
    createFourSideShot(){
        var that = this;
        let x:number = 0;
        let y:number = 0;
        
        for(var i=0;i<4;i++){
            switch(i){
                case 0:
                    x = that.getCenterP().x + 20;
                    y = that.getCenterP().y
                    var vector:FYGE.Point = new FYGE.Point(1,0);
                    break;
                case 1:
                    x = that.getCenterP().x;
                    y = that.getCenterP().y + 20;
                    var vector:FYGE.Point = new FYGE.Point(0,1);
                    break;
                case 2:
                    x = that.getCenterP().x - 20;
                    y = that.getCenterP().y;
                    var vector:FYGE.Point = new FYGE.Point(-1,0);
                    break;
                case 3:
                    x = that.getCenterP().x;
                    y = that.getCenterP().y - 20;
                    var vector:FYGE.Point = new FYGE.Point(0,-1);
                    break;
                default:break;
            }
            EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.enemyLayer,x,y,5,8,vector)
        }
        
    }

    playerCollsion(){
        var that = this;
        if(that.isDead) return;
        var player = GameManager.INS.playerPlane;
        if(rectCollsion(this.x,this.y,player.x,player.y,this.hitW,this.hitH,player.hitW,player.hitH)){
            player.hitDamage(1);
        }
    }

    horizonBounds(){
        var that = this;
        if(that.x<=that.bodyImg.width*0.2||(that.x>=(Ins.stageW-that.bodyImg.width*1.2))){
            that.speedVector.x = -that.speedVector.x;
        }
    }

    bossSetGoStage(){
        this.speedY = 1;
        this.speedVector.y = 1;
        this.speedX = this.speedVector.x = 0;
    }

    bossSetInStage(){
        this.speedY = 0;
        this.speedX = 1;
        this.worldTime = 0;
        if(this.speedVector.x == 0)
            this.speedVector.x = 1;
        this.speedVector.y = 0;
    }

    attackState(){
        this.curSkillIndex++;
        if(this.curSkillIndex>this.curSkillMax)
            this.curSkillIndex = 0;
    }

    setBody(uuid){
        this.bodyImg.texture = getTexture(uuid);
    }

    getCenterP(){
        var x = this.x + this.bodyImg.width*0.5;
        var y = this.y + this.bodyImg.height*0.5;
        return {x:x,y:y}
    }

        // /**发射6个剑子弹 */
    // createSixSword(offset?:number){
    //     var that = this;
    //     let targetX = 0;
    //     for(let i=0;i<6;i++){
    //         let originX:number = offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x - 90 + i*30;
    //         if(i<2){
    //             targetX = offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x - 120 + i*30;
    //         }else if(i<4){
    //             targetX = offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x - 90 + i*30;
    //         }else{
    //             targetX= offset?that.getCenterP().x - offset + i*offset:that.getCenterP().x + i*30;
    //         }
            
    //         let originY:number = that.y+that.bodyImg.height;
    //         let targetY:number = that.y+that.bodyImg.height+60;
    //         let vector:FYGE.Point = vectorUnit((targetX - originX),(targetY - originY));
    //         EnemyBulletManager.Ins.createBullet(that,LayerManager.Ins.bulletLayer,originX,originY,4,8,vector);
    //     }
    //     that.changeState(enemyState.inSatge);
    // }
}