import { BaseSprite } from "./BaseSprite";
import { getTexture } from "./utils";

export class UserHealth extends BaseSprite{
    health:number = 0;
    imgArr:FYGE.Sprite[] = [];
    constructor(x:number,y:number){
        super();
        this.x = x;
        this.y = y;
    }

    addToViewPort(){
        super.addToViewPort();
        this.health = 3;
        this.setHeartImg();
        this.addEvent();
    }

    addEvent(){

    }

    removeFromViewPort(){
        super.removeFromViewPort();
    }

    /**减少生命值 */
    reduceHealth(value:number){
        this.health -= value;
        for(var i=0;i<value;i++){
            var img = this.imgArr.pop();
            this.removeChild(img);
        }
    }

    /**增加生命值 */
    increaseHealth(value:number){
        for(var i=0;i<value;i++){
            var image = new FYGE.Sprite(getTexture("userHealth"));
            this.addChild(image);
            image.x = (i+this.health)*(image.width+20);
            this.imgArr.push(image);
        }
        this.health+=value;
    }

    /**设置生命值图片 */
    setHeartImg(){
        for(var i=0;i<this.health;i++){
            var image = new FYGE.Sprite(getTexture("userHealth"));
            this.addChild(image);
            image.x = i*(image.width+20);
            this.imgArr.push(image);
        }
    }
}