import * as FYGE from "fyge-tbmini";
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadSparkAssets(resList) {
        var list = [];
        for (var key in resList) {
            list.push(resList[key]);
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                if (s) {
                    resolve();
                }
                else {
                    reject();
                }
            }, list);
        });
        return p;
    }
    RES.loadSparkAssets = loadSparkAssets;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else {
                return new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, str);
                });
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i]['url'];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    RES.loadResList = loadResList;
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "skin")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "skin"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getSrcByUuid(resList, uuid) {
        resList = resList || [];
        for (var i = 0; i < resList.length; i++) {
            if (resList[i].uuid == uuid) {
                return resList[i].url;
            }
        }
        return "";
    }
    RES.getSrcByUuid = getSrcByUuid;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
exports.showToast = toastCtrl_2.showToast;
__export(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"));
exports.showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        if (toastBgTexture) {
            _this.bg = new FYGE.Sprite(toastBgTexture);
            _this.addChild(_this.bg);
        }
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture ? toastBgTexture.height : 200;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = ((this.bg ? this.bg.width : 0) - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        if (rectBgTexture) {
            var rectBg = new FYGE.Sprite(rectBgTexture);
            _this.addChild(rectBg);
            var rotTexture = RES_1.RES.getRes("waitingRot.png");
            var rot_1 = new FYGE.Sprite(rotTexture);
            rot_1.x = (rectBgTexture.width - rotTexture.width) / 2;
            rot_1.y = 47;
            rot_1.anchorX = rotTexture.width / 2;
            rot_1.anchorY = rotTexture.height / 2;
            _this.addChild(rot_1);
            var count_1 = 0;
            rot_1.addEventListener(FYGE.Event.ENTER_FRAME, function () {
                count_1++;
                if (count_1 % 30 == 0)
                    rot_1.rotation += 45;
            }, _this);
        }
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture ? rectBgTexture.width : 200;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.sceneLayer.y = this.stageOffsetY;
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: true,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./resCanvasList.js":
/*!**************************!*\
  !*** ./resCanvasList.js ***!
  \**************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const resCanvasList = {
      '9661f715-ac93-4344-b1e1-cdb423b4d58a': {
        name: '图层1',
        ext: '.png',
        uuid: '9661f715-ac93-4344-b1e1-cdb423b4d58a',
        url: '//yun.duiba.com.cn/spark/assets/50723d132ccf6a23691718e3ad0951605ead02b3.png'
      },
      'e92b7807-0c54-400f-930c-a5038126ea71': {
        name: '图层2',
        ext: '.png',
        uuid: 'e92b7807-0c54-400f-930c-a5038126ea71',
        url: '//yun.duiba.com.cn/spark/assets/462890005ffca52919645b23800f6d08ad09e39f.png'
      },
      '0e10dd45-fa85-4669-ac29-17e15dde29f2': {
        name: '图层3',
        ext: '.png',
        uuid: '0e10dd45-fa85-4669-ac29-17e15dde29f2',
        url: '//yun.duiba.com.cn/spark/assets/6252110856e2e726bc981587a4a6a3c5ac730681.png'
      },
      '8a0a8d24-c820-4d8d-9db9-e79c8c548829': {
        name: '关卡背景125',
        ext: '.png',
        uuid: '8a0a8d24-c820-4d8d-9db9-e79c8c548829',
        url: '//yun.duiba.com.cn/spark/assets/1034d57d27b9b7016b7588ad9bdf686df34a584c.png'
      },
      'c021144b-a1a1-4681-b7b3-24d99c5ab625': {
        name: '关卡背景114',
        ext: '.png',
        uuid: 'c021144b-a1a1-4681-b7b3-24d99c5ab625',
        url: '//yun.duiba.com.cn/spark/assets/11cd3ef1307996075bf980c40bc5e2a06f804a64.png'
      },
      '7e3ac1bd-bbcd-4073-83cf-dbd1268e1dc4': {
        name: '游戏引导',
        ext: '.png',
        url: '//yun.duiba.com.cn/spark/assets/游戏引导.5d0a0510fc718003aa3825081da82326d0e5d716.png',
        uuid: '7e3ac1bd-bbcd-4073-83cf-dbd1268e1dc4'
      },
      'd85a2de2-e81f-445a-84b0-a9049a9b1d70': {
        name: '关卡小标题01',
        ext: '.png',
        uuid: 'd85a2de2-e81f-445a-84b0-a9049a9b1d70',
        url: '//yun.duiba.com.cn/spark/assets/2e618a06bf1ed70a6986a3c618ecb63563fc5cfb.png'
      },
      '74f8e671-7638-40eb-bf95-16c04ee92948': {
        name: '关卡小标题02',
        ext: '.png',
        uuid: '74f8e671-7638-40eb-bf95-16c04ee92948',
        url: '//yun.duiba.com.cn/spark/assets/fa79914b96164c15bb3c51956f0da1c7f1eba864.png'
      },
      'c595ee27-a4e3-4084-8901-a9df5591c769': {
        name: '关卡小标题03',
        ext: '.png',
        uuid: 'c595ee27-a4e3-4084-8901-a9df5591c769',
        url: '//yun.duiba.com.cn/spark/assets/5171c88e517b2467de01a0f979ad0a4b288fa1af.png'
      },
      '38f581a2-9d96-4244-bcec-d0536375b8a6': {
        name: '关卡小标题04',
        ext: '.png',
        uuid: '38f581a2-9d96-4244-bcec-d0536375b8a6',
        url: '//yun.duiba.com.cn/spark/assets/a19572469336862408b277cb0c549901b8f98955.png'
      },
      'f0511077-9267-43de-9f09-bef6c7375a04': {
        name: '关卡小标题05',
        ext: '.png',
        uuid: 'f0511077-9267-43de-9f09-bef6c7375a04',
        url: '//yun.duiba.com.cn/spark/assets/78b878f2628db4dea6d71879ae2bb0f03c322733.png'
      },
      '9559f83d-9215-4c45-8d4c-030bd7b115d3': {
        name: '关卡小标题06',
        ext: '.png',
        uuid: '9559f83d-9215-4c45-8d4c-030bd7b115d3',
        url: '//yun.duiba.com.cn/spark/assets/ee93b8736fec5b1431c9aee33ec06cf1b12a4e77.png'
      },
      'aa29b4ab-e5ba-4156-97e1-28738f2f8453': {
        name: '图层545',
        ext: '.png',
        uuid: 'aa29b4ab-e5ba-4156-97e1-28738f2f8453',
        url: '//yun.duiba.com.cn/spark/assets/807317256624fc9e2d7aa080a5693b88a1cb0a43.png'
      },
      '7ce0d3de-cf71-495c-9c82-f75735f7ffd8': {
        name: '月亮115',
        ext: '.png',
        uuid: '7ce0d3de-cf71-495c-9c82-f75735f7ffd8',
        url: '//yun.duiba.com.cn/spark/assets/917659a62de48212403f88e8e602fb719868d662.png'
      },
      '5facc994-7d3a-4da8-9bf8-a2ceb7d2032e': {
        name: '星星117',
        ext: '.png',
        uuid: '5facc994-7d3a-4da8-9bf8-a2ceb7d2032e',
        url: '//yun.duiba.com.cn/spark/assets/a630ba136145311f7ef60c7d29d3e7dcfc2d288d.png'
      },
      '636340db-6418-4ca8-95bb-7b1930e8ced1': {
        name: '失败116',
        ext: '.png',
        uuid: '636340db-6418-4ca8-95bb-7b1930e8ced1',
        url: '//yun.duiba.com.cn/spark/assets/62d3aae9b2b49007aae56e2322dd11623e879939.png'
      },
      '1c69cf1a-b898-453d-b7a5-78ff638cf516': {
        name: '月亮79',
        ext: '.png',
        uuid: '1c69cf1a-b898-453d-b7a5-78ff638cf516',
        url: '//yun.duiba.com.cn/spark/assets/0f6439f8dac631319650e5d88fc8b3870ebcba7c.png'
      },
      '0c301127-1167-468f-8905-27cbd9d141d1': {
        name: '星星81',
        ext: '.png',
        uuid: '0c301127-1167-468f-8905-27cbd9d141d1',
        url: '//yun.duiba.com.cn/spark/assets/dab8a3e002b42611341e6866042666b24853097f.png'
      },
      'e2d857f7-3bc0-417c-bd52-10da4d912786': {
        name: '失败80',
        ext: '.png',
        uuid: 'e2d857f7-3bc0-417c-bd52-10da4d912786',
        url: '//yun.duiba.com.cn/spark/assets/73083bac3b1e120f76e7a6606f593f83ec67bbf7.png'
      },
      'abc359a6-ded8-4069-9da0-dbe93d78cf24': {
        name: '月亮22',
        ext: '.png',
        uuid: 'abc359a6-ded8-4069-9da0-dbe93d78cf24',
        url: '//yun.duiba.com.cn/spark/assets/ee071b17ff70444070c4ed46281df341e8fdbd74.png'
      },
      '5323f504-4a24-421a-9933-ef4064a5b8c0': {
        name: '星星24',
        ext: '.png',
        uuid: '5323f504-4a24-421a-9933-ef4064a5b8c0',
        url: '//yun.duiba.com.cn/spark/assets/2b13e40f441ac3fcb6ce636eee86f20275157cd2.png'
      },
      'f1f23612-84f9-46a3-97f5-714def17f17f': {
        name: '失败23',
        ext: '.png',
        uuid: 'f1f23612-84f9-46a3-97f5-714def17f17f',
        url: '//yun.duiba.com.cn/spark/assets/624cdc501874e5d06290319b6cd88ca5bc35b490.png'
      },
      '47d9b481-e72a-47a9-85d3-0c2e5e79c1e7': {
        name: '背景',
        ext: '.png',
        uuid: '47d9b481-e72a-47a9-85d3-0c2e5e79c1e7',
        url: '//yun.duiba.com.cn/spark-prod/assets/712aeca52eef61b47c8749eb75aacead450fde35.png'
      },
};
/* harmony default export */ __webpack_exports__["default"] = (resCanvasList);


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var StartScene_1 = __webpack_require__(/*! ./scenes/StartScene */ "./src/scenes/StartScene.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var resCanvasList_1 = __webpack_require__(/*! ../resCanvasList */ "./resCanvasList.js");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.WEBGL);
        this.stage = stage;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            self.requestID = FYGE.getRequestAnimationFrame()(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        return [4, RES_1.RES.loadSparkAssets(resCanvasList_1.default)];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        ctrls_1.changeScene(StartScene_1.StartScene);
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
        exports.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.ON_SHOW);
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.ON_HIDE);
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        FYGE.getCancelAnimationFrame()(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["trackingReport"] = "squirrelsAdoptRest2c.trackingReport";
    TbNetName["getIndex"] = "babycare.getIndex";
    TbNetName["getActivityBaseInfoById"] = "babycare.getActivityBaseInfoById";
    TbNetName["getGameInfo"] = "babycare.getGameInfo";
    TbNetName["consumerTools"] = "babycare.consumerTools";
    TbNetName["gameOver"] = "babycare.gameOver";
    TbNetName["receiveTaskRewards"] = "babycare.receiveTaskRewards";
    TbNetName["exchange"] = "babycare.exchange";
    TbNetName["getPrizesByLevel"] = "babycare.getPrizesByLevel";
    TbNetName["queryCredits"] = "babycare.queryCredits";
    TbNetName["dojoin"] = "babycare.dojoin";
    TbNetName["completeTask"] = "babycare.completeTask";
    TbNetName["getTaskList"] = "babycare.getTaskList";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        var waitObj;
        if (!my) {
            var url = "../../mock/miniTb/" + netName + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
            });
            return;
        }
        var fun = function (e) {
            ctrls_1.clearWait(waitObj);
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
            console.log("\n%c[ request ]\n"
                + ("NAME  : " + netName + " \n")
                + "STATE : %o \n"
                + "PARAM : %o \n"
                + "%cDATA  : %o \n", "" + (d.success ? 'color:green' : 'color:red'), d.success, parameter, "" + (d.success ? 'color:green' : 'color:red'), d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        waitObj = ctrls_1.wait(function () {
            if (netName != TbNetName.favorShop &&
                netName != TbNetName.getUserAddress &&
                netName != TbNetName.authorize &&
                netName != TbNetName.getAdoptName &&
                netName != TbNetName.trackingReport &&
                netName != TbNetName.reportAnalytics) {
                fun({ type: netName, data: { success: false } });
            }
        }, 10000);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "UpdateTask";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/common/MyEvent.ts":
/*!*******************************!*\
  !*** ./src/common/MyEvent.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MSG;
(function (MSG) {
    MSG["GAMESTART_CHANGECARDSTATUS"] = "GAMESTART_CHANGECARDSTATUS";
    MSG["GAMESTART_CHANGECARDPOS"] = "GAMESTART_CHANGECARDPOS";
    MSG["GAMESTART_CARDMOVE"] = "GAMESTART_CARDMOVE";
    MSG["GAMESTATR_CARDMOVEEND"] = "GAMESTART_CARDMOVEEND";
    MSG["GAME_SELETTRUE"] = "GAME_SELETTRUE";
    MSG["GAME_RESTART"] = "GAME_RESTART";
    MSG["GAME_START"] = "GAME_START";
    MSG["GAME_CLEARLEVEL"] = "GAME_CLEARLEVEL";
    MSG["GAME_FAILED"] = "GAME_FAILED1";
    MSG["GAME_SUCCESS"] = "GAME_SUCCESS";
})(MSG = exports.MSG || (exports.MSG = {}));


/***/ }),

/***/ "./src/scenes/StartScene.ts":
/*!**********************************!*\
  !*** ./src/scenes/StartScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var resCanvasList_1 = __webpack_require__(/*! ../../../game/resCanvasList */ "./resCanvasList.js");
var card_1 = __webpack_require__(/*! ../sprite/card */ "./src/sprite/card.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var MyEvent_1 = __webpack_require__(/*! ../common/MyEvent */ "./src/common/MyEvent.ts");
var StartScene = (function (_super) {
    __extends(StartScene, _super);
    function StartScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.rows = [];
        _this.cols = [];
        _this.minLevel = 1;
        _this.maxLevel = 6;
        _this.levelTitleUUidArr = [];
        _this.countDownCnt = 3;
        _this.countDownUUidArr = [];
        _this.offsetX = [];
        _this.offsetY = [];
        _this.offsetX1 = [];
        _this.offsetY1 = [];
        _this.cardArr = [];
        _this.changeCardArr = [];
        _this.cardSize = [];
        _this.trueCardCnt = [];
        _this.levelSizeArr = [];
        _this.randomCntArr = [];
        return _this;
    }
    StartScene.prototype.initUi = function () {
        var that = this;
        that.initData();
        that.initObj();
    };
    StartScene.prototype.initData = function () {
        var that = this;
        that.selectTureCnt = 0;
        that.curLevel = 3;
        that.countDownCnt = 3;
        that.rows = [2, 3, 3, 3, 4, 4];
        that.cols = [2, 3, 3, 3, 4, 4];
        that.cardSize = [{ w: 313, h: 314 }, { w: 206, h: 207 }, { w: 158, h: 158 }];
        that.trueCardCnt = [1, 1, 2, 3, 2, 3];
        that.levelSizeArr = [0, 1, 1, 1, 2, 2];
        that.randomCntArr = [1, 2, 3, 4, 6, 6];
        that.offsetX = [20, 18, 18, 18, 16, 16];
        that.offsetY = [20, 18, 18, 18, 12, 12];
        that.offsetX1 = [14, 14, 14, 14, 6, 6];
        that.offsetY1 = [14, 12, 12, 12, 8, 8];
        that.countDownUUidArr = ["0e10dd45-fa85-4669-ac29-17e15dde29f2", "e92b7807-0c54-400f-930c-a5038126ea71", "9661f715-ac93-4344-b1e1-cdb423b4d58a"];
        that.levelTitleUUidArr = ["d85a2de2-e81f-445a-84b0-a9049a9b1d70", "74f8e671-7638-40eb-bf95-16c04ee92948", "c595ee27-a4e3-4084-8901-a9df5591c769",
            "38f581a2-9d96-4244-bcec-d0536375b8a6", "f0511077-9267-43de-9f09-bef6c7375a04", "9559f83d-9215-4c45-8d4c-030bd7b115d3"];
    };
    StartScene.prototype.initObj = function () {
        var that = this;
        console.log("初始化");
        that.stageW = that.stage.viewRect.width;
        that.stageH = that.stage.viewRect.height;
        that.gameBg = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default["47d9b481-e72a-47a9-85d3-0c2e5e79c1e7"].url));
        that.gameBg.x = (that.stageW - that.gameBg.width) >> 1;
        that.gameBg.y = (that.stageH - that.gameBg.height) >> 1;
        that.addChild(that.gameBg);
        that.levelGroup = new FYGE.Sprite();
        that.addChild(that.levelGroup);
        that.countDownGroup = new FYGE.Sprite();
        that.addChild(that.countDownGroup);
        that.countDownGroup.visible = false;
        that.guideGroup = new FYGE.Sprite();
        that.addChild(that.guideGroup);
        that.guideGroup.visible = false;
        that.guideImg = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default["7e3ac1bd-bbcd-4073-83cf-dbd1268e1dc4"].url));
        that.guideGroup.addChild(that.guideImg);
        that.guideImg.x = (that.stageW - that.guideImg.width) >> 1;
        that.guideImg.y = (that.stageH - that.guideImg.height) >> 1;
        that.countDownBg = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default["aa29b4ab-e5ba-4156-97e1-28738f2f8453"].url));
        that.countDownBg.alpha = 0.7;
        that.countDownGroup.addChild(that.countDownBg);
        that.countDown = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default[that.countDownUUidArr[0]].url));
        that.countDown.anchorX = that.countDown.width >> 1;
        that.countDown.anchorY = that.countDown.height >> 1;
        that.countDown.x = (that.stage.viewRect.width - that.countDown.width) >> 1;
        that.countDown.y = (that.stage.viewRect.height - that.countDown.height) >> 1;
        that.countDownGroup.addChild(that.countDown);
        that.levelBg = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default["8a0a8d24-c820-4d8d-9db9-e79c8c548829"].url));
        that.levelBg.x = (that.stage.viewRect.width - that.levelBg.width) * 0.5;
        that.levelBg.y = (that.stage.viewRect.height - that.levelBg.height - 110) * 0.5;
        that.levelGroup.addChild(that.levelBg);
        that.levelTitle = new FYGE.Sprite(RES_1.RES.getRes(resCanvasList_1.default[that.levelTitleUUidArr[0]].url));
        that.levelTitle.x = that.levelBg.x;
        that.levelTitle.y = that.levelBg.y + 100;
        that.levelGroup.addChild(that.levelTitle);
        that.cardGourp = new FYGE.Sprite();
        that.cardGourp.x = that.levelBg.x;
        that.cardGourp.y = that.levelBg.y + 206;
        that.levelGroup.addChild(that.cardGourp);
    };
    StartScene.prototype.start = function (data) {
        _super.prototype.start.call(this);
        var that = this;
        that.curLevel = 0;
        that.initNewLevel();
        var newPlayer = localStorage.getItem("mrzzNewPlayer");
        if (!newPlayer) {
            that.guideGroup.visible = true;
            localStorage.setItem("mrzzNewPlayer", "yes");
        }
        else {
            that.startCountDown();
        }
    };
    StartScene.prototype.nextLevel = function () {
        console.log("进入新关卡");
        var that = this;
        that.startCountDown();
    };
    StartScene.prototype.initNewLevel = function () {
        var that = this;
        that.curLevel++;
        if (that.curLevel > that.maxLevel)
            return;
        for (var i = 0; i < that.cardArr.length; i++) {
            that.cardArr[i].parent.removeChild(that.cardArr[i]);
            that.cardArr.splice(i, 1);
            i--;
        }
        that.changeCardArr.splice(0);
        that.selectTureCnt = 0;
        that.setMap();
    };
    StartScene.prototype.startCountDown = function () {
        var that = this;
        that.guideGroup.visible = false;
        that.countDownGroup.visible = true;
        that.countDownCnt = 3;
        that.countDown.texture = RES_1.RES.getRes(resCanvasList_1.default[that.countDownUUidArr[that.countDownUUidArr.length - that.countDownCnt]].url);
        that.countDown.x = (that.stage.viewRect.width - that.countDown.width) >> 1;
        that.countDown.y = (that.stage.viewRect.height - that.countDown.height) >> 1;
        var timeCnt = setInterval(function () {
            that.countDownCnt--;
            if (that.countDownCnt > 0) {
                that.countDown.texture = RES_1.RES.getRes(resCanvasList_1.default[that.countDownUUidArr[that.countDownUUidArr.length - that.countDownCnt]].url);
                that.countDown.x = (that.stage.viewRect.width - that.countDown.width) >> 1;
                that.countDown.y = (that.stage.viewRect.height - that.countDown.height) >> 1;
            }
            else {
                that.countDownGroup.visible = false;
                that.randomSetPosCnt = that.randomCntArr[that.curLevel - 1];
                Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTART_CHANGECARDSTATUS);
                clearInterval(timeCnt);
            }
        }, 1000);
    };
    StartScene.prototype.setMap = function () {
        var that = this;
        var col = that.cols[that.curLevel - 1];
        var row = that.rows[that.curLevel - 1];
        var cnt = col * row;
        var offsetX = that.offsetX[that.curLevel - 1];
        var offsetY = that.offsetY[that.curLevel - 1];
        var offsetX1 = that.offsetX1[that.curLevel - 1];
        var offsetY1 = that.offsetY1[that.curLevel - 1];
        var trueCnt = that.trueCardCnt[that.curLevel - 1];
        var size = that.levelSizeArr[that.curLevel - 1];
        for (var i = 0; i < cnt; i++) {
            if (trueCnt > 0) {
                if (Math.random() < 0.2) {
                    var type = 1;
                    trueCnt--;
                }
                else if (trueCnt == (cnt - i)) {
                    var type = 1;
                    trueCnt--;
                }
                else {
                    var type = 0;
                }
            }
            else {
                var type = 0;
            }
            var card = new card_1.Card({ id: i, type: type, size: size });
            console.log(type);
            that.cardGourp.addChild(card);
            card.x = offsetX + i % col * (that.cardSize[size].w + offsetX1);
            card.y = offsetY + Math.floor(i / col) * (that.cardSize[size].h + offsetY1);
            that.cardArr.push(card);
        }
        that.cardGourp.mouseChildren = true;
        that.levelTitle.texture = RES_1.RES.getRes(resCanvasList_1.default[that.levelTitleUUidArr[that.curLevel - 1]].url);
    };
    StartScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.guideGroup.addEventListener(FYGE.MouseEvent.CLICK, this.startCountDown, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAMESTART_CHANGECARDPOS, this.changeCardPos, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND, this.cardMoveEnd, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAME_FAILED, this.gameFailed, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAME_SELETTRUE, this.gameClearLevel, this);
        Main_1.GDispatcher.addEventListener("nextLevel", this.nextLevel, this);
    };
    StartScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.guideGroup.removeEventListener(FYGE.MouseEvent.CLICK, this.startCountDown, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAMESTART_CHANGECARDPOS, this.changeCardPos, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND, this.cardMoveEnd, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAME_FAILED, this.gameFailed, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAME_SELETTRUE, this.gameClearLevel, this);
        Main_1.GDispatcher.removeEventListener("nextLevel", this.nextLevel, this);
    };
    StartScene.prototype.changeCardPos = function () {
        var that = this;
        for (var i = 0; i < that.cardArr.length; i++) {
            if (!that.cardArr[i].changeStateEnd)
                return;
        }
        if (that.randomSetPosCnt <= 0) {
            console.log("游戏开始");
            Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAME_START);
            return;
        }
        else {
            that.randomSetPosCnt--;
        }
        console.log("改变位置");
        var cardArr = that.cardArr;
        var col = that.cols[that.curLevel - 1];
        var row = that.rows[that.curLevel - 1];
        var index = Math.floor(Math.random() * that.cardArr.length);
        if (Math.random() > 0.5) {
            var left = fundLeft(index);
            if (!left) {
                var right = fundRight(index);
            }
        }
        else {
            var right = fundRight(index);
            if (!right) {
                var left = fundLeft(index);
            }
        }
        console.log("aaaa", index, left, right);
        if (Math.random() > 0.5) {
            var up = fundUp(index);
            if (!up) {
                var down = fundDown(index);
            }
        }
        else {
            var down = fundDown(index);
            if (!down) {
                var up = fundUp(index);
            }
        }
        console.log("bbbb", index, up, down);
        that.setRectRange(index, left, right, up, down);
        function fundLeft(index) {
            var leftIndex = index - 1;
            if (cardArr[leftIndex] && cardArr[index].y == cardArr[leftIndex].y) {
                var nextLeftIndex = leftIndex - 1;
                if (cardArr[nextLeftIndex] && cardArr[leftIndex].y == cardArr[nextLeftIndex].y) {
                    leftIndex = nextLeftIndex;
                    nextLeftIndex = leftIndex - 1;
                    if (cardArr[nextLeftIndex] && cardArr[leftIndex].y == cardArr[nextLeftIndex].y) {
                        leftIndex = nextLeftIndex;
                        return leftIndex;
                    }
                    else {
                        return leftIndex;
                    }
                }
                else {
                    return leftIndex;
                }
            }
            else {
                return undefined;
            }
        }
        function fundRight(index) {
            var rightIndex = index + 1;
            if (cardArr[rightIndex] && cardArr[index].y == cardArr[rightIndex].y) {
                var nextRightIndex = rightIndex + 1;
                if (cardArr[nextRightIndex] && cardArr[rightIndex].y == cardArr[nextRightIndex].y) {
                    rightIndex = nextRightIndex;
                    nextRightIndex = rightIndex + 1;
                    if (cardArr[nextRightIndex] && cardArr[rightIndex].y == cardArr[nextRightIndex].y) {
                        rightIndex = nextRightIndex;
                        return rightIndex;
                    }
                    else {
                        return rightIndex;
                    }
                }
                else {
                    return rightIndex;
                }
            }
            else {
                return undefined;
            }
        }
        function fundUp(index) {
            var upIndex = index - col;
            if (cardArr[upIndex] && cardArr[index].x == cardArr[upIndex].x) {
                var nextUpIndex = upIndex - col;
                if (cardArr[nextUpIndex] && cardArr[upIndex].x == cardArr[nextUpIndex].x) {
                    upIndex = nextUpIndex;
                    nextUpIndex = upIndex - col;
                    if (cardArr[nextUpIndex] && cardArr[upIndex].x == cardArr[nextUpIndex].x) {
                        upIndex = nextUpIndex;
                        return upIndex;
                    }
                    else {
                        return upIndex;
                    }
                }
                else {
                    return upIndex;
                }
            }
            else {
                return undefined;
            }
        }
        function fundDown(index) {
            var downIndex = index + col;
            if (cardArr[downIndex] && cardArr[index].x == cardArr[downIndex].x) {
                var nextDownIndex = downIndex + col;
                if (cardArr[nextDownIndex] && cardArr[downIndex].x == cardArr[nextDownIndex].x) {
                    downIndex = nextDownIndex;
                    nextDownIndex = downIndex + col;
                    if (cardArr[nextDownIndex] && cardArr[downIndex].x == cardArr[nextDownIndex].x) {
                        downIndex = nextDownIndex;
                        return downIndex;
                    }
                    else {
                        return downIndex;
                    }
                }
                else {
                    return downIndex;
                }
            }
            else {
                return undefined;
            }
        }
    };
    StartScene.prototype.setRectRange = function (index, left, right, up, down) {
        console.log(left, right, up, down);
        var that = this;
        var x;
        var y;
        var w;
        var h;
        if (left >= 0) {
            x = that.cardArr[left].x;
            w = Math.abs(that.cardArr[index].x - that.cardArr[left].x);
            console.log("left", left);
        }
        else {
            x = that.cardArr[index].x;
            w = Math.abs(that.cardArr[index].x - that.cardArr[right].x);
            console.log("right", right);
        }
        if (up >= 0) {
            y = that.cardArr[up].y;
            h = Math.abs(that.cardArr[index].y - that.cardArr[up].y);
            console.log("up", up);
        }
        else {
            y = that.cardArr[index].y;
            h = Math.abs(that.cardArr[index].y - that.cardArr[down].y);
            console.log("down", down);
        }
        console.log(x, y, w, h);
        var offsetX1 = that.offsetX1[that.curLevel - 1];
        var offsetY1 = that.offsetY1[that.curLevel - 1];
        var size = that.levelSizeArr[that.curLevel - 1];
        var col = that.cols[that.curLevel - 1];
        var row = that.rows[that.curLevel - 1];
        that.changeCardArr = [];
        that.randomCardMoveCnt = Math.floor(Math.random() * 3) + 2;
        for (var i = 0; i < that.cardArr.length; i++) {
            if ((that.cardArr[i].x <= (x + w) && that.cardArr[i].x >= x && that.cardArr[i].y >= y && that.cardArr[i].y <= (y + h))
                && (that.cardArr[i].x == x || that.cardArr[i].x == (x + w) || that.cardArr[i].y == y || that.cardArr[i].y == (y + h))) {
                that.cardArr[i].isMoveCard = true;
                that.changeCardArr.push(that.cardArr[i]);
                that.cardArr[i].setMoveStatus(x, y, w, h, col, row, that.cardSize[size].w + offsetX1, that.cardSize[size].h + offsetY1);
                that.cardArr.splice(i, 1);
                i--;
            }
            else {
                that.cardArr[i].isMoveCard = false;
            }
        }
        Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTART_CARDMOVE);
    };
    StartScene.prototype.cardMoveEnd = function () {
        for (var i = 0; i < this.changeCardArr.length; i++) {
            if (this.changeCardArr[i].isMoving) {
                return;
            }
        }
        console.log("变换前卡牌", this.cardArr);
        this.randomCardMoveCnt--;
        if (this.randomCardMoveCnt <= 0) {
            this.cardArr = this.cardArr.concat(this.changeCardArr);
            this.cardArr.sort(function (a, b) { return a.id - b.id; });
            console.log("变换后的卡牌", this.cardArr);
            this.changeCardPos();
        }
        else {
            Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTART_CARDMOVE);
        }
    };
    StartScene.prototype.gameFailed = function () {
        console.log("选错啦，失败啦");
        var e = new Event("GAME_FAILED");
        document.dispatchEvent(e);
    };
    StartScene.prototype.gameClearLevel = function () {
        var that = this;
        that.selectTureCnt++;
        var trueCnt = that.trueCardCnt[that.curLevel - 1];
        if (that.selectTureCnt >= trueCnt) {
            that.selectTureCnt = 0;
            that.initNewLevel();
            if ((that.curLevel - 1) >= that.maxLevel) {
                console.log("通过所有关卡");
                var e = new Event("GAME_SUCCESS");
                document.dispatchEvent(e);
            }
            else {
                console.log("通过当前关卡");
                var level = that.curLevel - 1;
                var event_1 = new CustomEvent("GAME_CLEARCURLEVEL", { detail: { level: level } });
                document.dispatchEvent(event_1);
            }
        }
    };
    return StartScene;
}(Scene_1.Scene));
exports.StartScene = StartScene;


/***/ }),

/***/ "./src/sprite/card.ts":
/*!****************************!*\
  !*** ./src/sprite/card.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ../../module/views/Module */ "./module/views/Module.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var resCanvasList_1 = __webpack_require__(/*! ../../../game/resCanvasList */ "./resCanvasList.js");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var MyEvent_1 = __webpack_require__(/*! ../common/MyEvent */ "./src/common/MyEvent.ts");
var Card = (function (_super) {
    __extends(Card, _super);
    function Card(data) {
        var _this = _super.call(this, data) || this;
        _this.isMoveCard = false;
        _this.changeStateEnd = false;
        _this.moveDir = 0;
        _this.moveDuration = 500;
        _this.changeStateDuration = 260;
        _this.isMoving = false;
        _this.isDebug = false;
        _this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, _this.removeEvents, _this);
        return _this;
    }
    Card.prototype.initUi = function () {
        var that = this;
        that.id = that.data.id;
        that.size = that.data.size;
        that.type = that.data.type;
        that.cardNormalUUidArr = ["5facc994-7d3a-4da8-9bf8-a2ceb7d2032e", "0c301127-1167-468f-8905-27cbd9d141d1", "5323f504-4a24-421a-9933-ef4064a5b8c0"];
        that.cardTrueUUidArr = ["7ce0d3de-cf71-495c-9c82-f75735f7ffd8", "1c69cf1a-b898-453d-b7a5-78ff638cf516", "abc359a6-ded8-4069-9da0-dbe93d78cf24"];
        that.cardFalseUUidArr = ["636340db-6418-4ca8-95bb-7b1930e8ced1", "e2d857f7-3bc0-417c-bd52-10da4d912786", "f1f23612-84f9-46a3-97f5-714def17f17f"];
        console.log("卡牌初始化啦");
        that.initCard();
        that.initEvents();
    };
    Card.prototype.initCard = function () {
        var that = this;
        that.cardImg = new FYGE.Sprite();
        that.cardImg.mouseEnable = false;
        that.addChild(that.cardImg);
        if (that.isDebug && that.type == 1) {
            var label = new FYGE.TextField();
            label.text = "我是对的";
            label.size = 50;
            label.fillColor = "000";
            that.addChild(label);
            label.mouseEnable = false;
        }
        that.setCardImgByType(that.type, true);
    };
    Card.prototype.setCardImgByType = function (type, setAnchor) {
        if (setAnchor === void 0) { setAnchor = false; }
        var that = this;
        var texture;
        switch (type) {
            case 0:
                texture = RES_1.RES.getRes(resCanvasList_1.default[that.cardNormalUUidArr[that.size]].url);
                break;
            case 1:
                texture = RES_1.RES.getRes(resCanvasList_1.default[that.cardTrueUUidArr[that.size]].url);
                break;
            case 2:
                texture = RES_1.RES.getRes(resCanvasList_1.default[that.cardFalseUUidArr[that.size]].url);
                break;
            default:
                console.error("卡片类型设置错误");
                break;
        }
        that.cardImg.texture = texture;
        if (setAnchor) {
            that.cardImg.anchorX = that.cardImg.width * 0.5;
            that.cardImg.anchorY = that.cardImg.height * 0.5;
        }
    };
    Card.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    Card.prototype.initEvents = function () {
        this.cardImg.addEventListener(FYGE.MouseEvent.CLICK, this.select, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAMESTART_CHANGECARDSTATUS, this.setNorMalState, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAMESTART_CARDMOVE, this.cardMove, this);
        Main_1.GDispatcher.addEventListener(MyEvent_1.MSG.GAME_START, this.gameStart, this);
    };
    Card.prototype.removeEvents = function () {
        this.cardImg.removeEventListener(FYGE.MouseEvent.CLICK, this.select, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAMESTART_CHANGECARDSTATUS, this.setNorMalState, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAMESTART_CARDMOVE, this.cardMove, this);
        Main_1.GDispatcher.removeEventListener(MyEvent_1.MSG.GAME_START, this.gameStart, this);
    };
    Card.prototype.gameStart = function () {
        this.cardImg.mouseEnable = true;
    };
    Card.prototype.select = function () {
        console.log("选择卡牌");
        var that = this;
        this.parent.mouseChildren = false;
        FYGE.Tween.get(that.cardImg).to({ scaleX: 0 }, that.changeStateDuration).call(function () {
            if (that.type == 1) {
                that.setCardImgByType(1);
            }
            else {
                that.setCardImgByType(2);
            }
        }).to({ scaleX: 1 }, that.changeStateDuration).call(function () {
            if (that.type == 1) {
                that.mouseEnable = false;
                that.mouseChildren = false;
                console.log("选对啦");
                Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAME_SELETTRUE);
            }
            else {
                that.mouseEnable = false;
                that.mouseChildren = false;
                console.log("选错啦");
                Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAME_FAILED);
            }
            setTimeout(function () {
                if (that && that.parent) {
                    that.parent.mouseChildren = true;
                }
            }, 100);
        });
    };
    Card.prototype.setNorMalState = function () {
        var that = this;
        if (that.type == 1) {
            FYGE.Tween.get(that.cardImg).to({ scaleX: 0 }, that.changeStateDuration).call(function () {
                that.setCardImgByType(0);
            }).to({ scaleX: 1 }, that.changeStateDuration).call(function () {
                that.changeStateEnd = true;
                Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTART_CHANGECARDPOS);
            });
        }
        else {
            that.changeStateEnd = true;
        }
    };
    Card.prototype.cardMove = function () {
        var that = this;
        if (that.isMoveCard) {
            that.getDir();
        }
    };
    Card.prototype.getDir = function () {
        var that = this;
        if (that.x == that.rangeX) {
            if (that.y == that.rangeY) {
                that.moveDir = 0;
            }
            else {
                that.moveDir = 2;
            }
        }
        else if (that.x == (that.rangeX + that.rangeW)) {
            if (that.y == (that.rangeY + that.rangeH)) {
                that.moveDir = 1;
            }
            else {
                that.moveDir = 3;
            }
        }
        else {
            if (that.y == that.rangeY) {
                that.moveDir = 0;
            }
            else if (that.y == that.rangeY + that.rangeH) {
                that.moveDir = 1;
            }
        }
        that.move();
    };
    Card.prototype.move = function () {
        var that = this;
        that.isMoving = true;
        switch (that.moveDir) {
            case 0:
                FYGE.Tween.get(that).to({ x: that.x + that.moveLengthX }, 500).wait(50).call(function () {
                    that.id++;
                    that.isMoving = false;
                    Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND);
                });
                break;
            case 1:
                FYGE.Tween.get(that).to({ x: that.x - that.moveLengthX }, 500).wait(50).call(function () {
                    that.isMoving = false;
                    that.id--;
                    Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND);
                });
                break;
            case 2:
                FYGE.Tween.get(that).to({ y: that.y - that.moveLengthY }, 500).wait(50).call(function () {
                    that.isMoving = false;
                    that.id -= that.col;
                    Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND);
                });
                break;
            case 3:
                FYGE.Tween.get(that).to({ y: that.y + that.moveLengthY }, 500).wait(50).call(function () {
                    that.isMoving = false;
                    that.id += that.col;
                    Main_1.GDispatcher.dispatchEvent(MyEvent_1.MSG.GAMESTATR_CARDMOVEEND);
                });
                break;
        }
    };
    Card.prototype.changeState = function () {
    };
    Card.prototype.setMoveStatus = function (x, y, w, h, col, row, moveLengthX, moveLengthY) {
        var that = this;
        that.rangeX = x;
        that.rangeY = y;
        that.rangeW = w;
        that.rangeH = h;
        that.col = col;
        that.row = row;
        that.moveLengthX = moveLengthX;
        that.moveLengthY = moveLengthY;
    };
    Card.prototype.getCardSize = function () {
        return { w: this.cardImg.width, h: this.cardImg.height };
    };
    return Card;
}(Module_1.Module));
exports.Card = Card;


/***/ })

/******/ });
});
//# sourceMappingURL=output.js.map