import { Scene } from "../../module/views/Scene";
import { showPanel, showWaiting, hideWaiting, showToast, changeScene } from "../../module/ctrls";
import { RulePanel } from "./RulePanel";
import { Tools } from "../Tools";
import { layers } from "../../module/views/layers";
import { GDispatcher } from "../Main";
import { G_EVENT } from "../common/G_EVENT";
import { PlayScene } from "./PlayScene";
import { sendWebNet, WebNetName } from "../WebNet";
import { RES } from "../../module/RES";
export class StartScene extends Scene {
    get groupNames() { return ["StartScene"] }
    // get skinName() { return "StartScene" }
    taskBtn: FYGE.Button;
    lotBtn: FYGE.Button;
    rankBtn: FYGE.Button;
    timesTxt: FYGE.TextField;
    startBtn: FYGE.Button;
    ruleBtn: FYGE.Button;
    recordBtn: FYGE.Button;


    initUi() {
        console.log('aa-->', layers.stageWidth, layers.stageHeight)
        // this.y -= layers.stageOffsetY;
        //次数文案居中
        // Tools.changeTextAlign(this.timesTxt, FYGE.TEXT_ALIGN.CENTER, 300);
        // let text = new FYGE.TextField();
        // this.addChild(text)
        // text.x = 1000;
        // text.y = 600;
        // text.text = '这是个1920*1080'
        // text.size = 60;
        // let animArr = [];
        // for (let i = 0; i < 12; i++) {
        //     animArr.push(RES.getRes(`run_${i + 1}.png`))
        // }
        // let anim: FYGE.FrameAni = new FYGE.FrameAni(animArr);
        // anim.scale.set(2, 2);
        // anim.position.set(800, 500)
        // anim.frameRate = 16;
        // anim.play(0);
        // this.addChild(anim);
        // return;

        //加滚动
        if (layers.stageHeight < 1624) {
            var scroll = new FYGE.ScrollPage(750, layers.stageHeight, 1624 - layers.stageOffsetY, true, true)
            // 所有内容加入滚动
            // this.children.forEach((c)=>{ //这种方式有问题，因为子级的索引
            // 	scroll.view.addChild(c);
            // })
            scroll.view.addChildren(...this.removeChildren());
            // scroll.view.addChildren.apply(scroll.view,this.removeChildren())
            // //滚动加入加入父级
            this.addChild(scroll);
        }
    }

    async start(data) {
        super.start()
        //次数文案修改
        // this.timesTxt.text = "剩余次数：" + this.data.gameCounts + "次";
    }
    initEvents() {
        super.initEvents();
        return;
        //开始游戏
        this.startBtn.addEventListener(FYGE.MouseEvent.CLICK, async () => {
            showWaiting();
            var res = await sendWebNet(WebNetName.join)
            hideWaiting();
            if (res.success) {
                changeScene(PlayScene, { ...res.data });
            } else {
                //TODO
            }
        }, this)
        //规则按钮
        this.ruleBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            showPanel(RulePanel)
        }, this)
        //我的奖品按钮
        this.recordBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            //弄个延时
            Tools.btnDelay(this.recordBtn)
            //跳转，链接待定
            location.href = window["recordUrl"];
        }, this)
        //排行榜按钮
        this.rankBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            console.log("点击了排行榜弹框")
        }, this)
        //任务弹框
        this.taskBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            console.log("点击了任务弹框")
        }, this)

        //监听下次数修改
        GDispatcher.addEventListener(G_EVENT.UPDATE_SCENE, this.updateScene, this);
    }
    removeEvents() {
        super.removeEvents();
        //移除次数监听
        GDispatcher.removeEventListener(G_EVENT.UPDATE_SCENE, this.updateScene, this);
        //其他的按钮事件不写了，没存引用，反正destroy会把挂在场景上的所有显示对象的事件都清除
    }
}
