import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { getWebData, sendWebNet, WebNetName } from "../WebNet";

let section;
export class RulePanel extends Panel {
	get groupNames() { return ["RulePanel"] }
	get skinName() { return "RulePanel" }
	ruleTxt: FYGE.TextField;
	knowBtn: FYGE.Button;
	closeBtn: FYGE.Button;

	//两个按钮都是关闭作用
	get closeBtns() {
		return [this.closeBtn, this.knowBtn];
	}

	async start(data) {
		super.start();
		//取接口数据
		const res = await sendWebNet(WebNetName.projectRule)
		if (!res.success) return
		var ruleStr = res.data;
		//原先视图上有一个
		this.removeChild(this.ruleTxt);
		this.addChild(this.closeBtn);
		console.log(this.closeBtn)
		//文案
		// var scroll = this.addChild(new FYGE.ScrollPage(610, 816, 100, true, false))
		// scroll.position.copy(this.ruleTxt.position)
		
		// //加文案
		// var txt = scroll.view.addChild(Tools.getText(
		// 	ruleStr,
		// 	30,//this.ruleTxt.size,
		// 	this.ruleTxt.fillColor,
		// 	FYGE.TEXT_ALIGN.LEFT,
		// 	610
		// ))
		// //多行设置
		// txt.lineType = FYGE.TEXT_lINETYPE.MULTI;
		// //行间距设置
		// txt.lineSpacing = 20;
		// //滚动最大长度按文本高度
		// scroll.maxDistance = txt.textHeight

		if (!section) {//避免文案过长，用这种方式
			document.getElementById("cusEngine").style.position = "absolute"
			section = document.createElement('section');
			section.id = "rule";
			section.style.overflowX = "hidden";
			section.style.overflowY = "auto";
			section.style.width = 610 + "px";
			section.style.height = 816 + "px";
			section.style.lineHeight = 48 + "px";
			section.style.fontSize = this.ruleTxt.size + 'px';
			section.style.color = this.ruleTxt.fillColor;
			section.style.whiteSpace = "pre-line";
			section.innerHTML = ruleStr;
		}
		var rule = this.addChild(new FYGE.FloatDisplay());
		rule.position.set(this.ruleTxt.x, this.ruleTxt.y)
		rule.init(section);
	}
}


const ruleTemplate = `啊企鹅去欧文u去外婆偶尔u欺骗我如情人坡i去哦日期【人贫穷人品【去哦微软【哦前往平壤【 去哦【让我气泡【让我去【王培荣亲王【人跑去欧文人【强我弱【\n 去哦人权为荣哦破千万人脾气【微软哦亲哦人气泡【 人游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则`
