import { GDispatcher } from "../../Main";
import { Msg } from "../Message/Msg";
import Player from "./Player";


export default class PlayerController {
    private static _instance: PlayerController;
    static get instance() {
        if (!this._instance) this._instance = new PlayerController();
        return this._instance;
    }

    constructor() {
        this.initKeyController();
    }

    private _player: Player;

    set player(player: Player) {
        this._player = player;
    }

    get player() {
        return this._player;
    }

    /**初始化键盘控制 */
    initKeyController() {
        document.onkeydown = (e) => {
            console.log('测试控制器按键--->>', e.code)
            switch (e.code) {
                case 'KeyW':
                    GDispatcher.dispatchEvent(Msg.onKeyW);
                    break;
                case 'KeyA':
                    GDispatcher.dispatchEvent(Msg.onKeyA);
                    break;
                case 'KeyD':
                    GDispatcher.dispatchEvent(Msg.onKeyD);
                    break;
                case 'KeyS':
                    GDispatcher.dispatchEvent(Msg.onKeyS);
                    break;
                case 'KeyJ':
                    GDispatcher.dispatchEvent(Msg.onKeyJ);
                    break;
                case 'KeyK':
                    GDispatcher.dispatchEvent(Msg.onKeyK);
                    break;
                default:
                    break;
            }
        }

        document.onkeyup = (e)=>{
            switch (e.code) {
                case 'KeyW':
                    GDispatcher.dispatchEvent(Msg.onKeyUpW);
                    break;
                case 'KeyA':
                    GDispatcher.dispatchEvent(Msg.onKeyUpA);
                    break;
                case 'KeyD':
                    GDispatcher.dispatchEvent(Msg.onKeyUpD);
                    break;
                case 'KeyS':
                    GDispatcher.dispatchEvent(Msg.onKeyUpS);
                    break;
                case 'KeyJ':
                    GDispatcher.dispatchEvent(Msg.onKeyUpJ);
                    break;
                case 'KeyK':
                    GDispatcher.dispatchEvent(Msg.onKeyUpK);
                    break;
                default:
                    break;
            }
        }
    }
}