import CollsionComp from "../Component/CollsionComp";
import WeaponCollsionComp from "../Component/WeaponCollsionComp";
import { COLLSION_GROUP, COLLSION_TYPE } from "../Enum/CollsionGroup";
import { CollsionComStuct } from "../Struct/CollsionComStruct";

export default class CollsionMgr {
    private static _instance: CollsionMgr;
    static get instance() {
        if (!this._instance) this._instance = new CollsionMgr();
        return this._instance;
    }
    collsionComArr: CollsionComp[] = [];

    setCollsionComp(data: CollsionComStuct): CollsionComp {
        let collsion = new CollsionComp();
        collsion.x1 = data.x;
        collsion.y1 = data.y;
        collsion.w = data.w;
        collsion.h = data.h;
        collsion.r = data.r;
        collsion.collsionType = data.collsionType;
        collsion.collsionGroup = data.collsionGroup;
        collsion.owner = data.owner;
        collsion.owner.addChildAt(collsion, 0);
        this.collsionComArr.push(collsion);
        return collsion;
    }

    setWeaponCollsionComp(damage: number, vTime: number, data: CollsionComStuct) {
        let collsion = new WeaponCollsionComp();
        collsion.x1 = data.x;
        collsion.y1 = data.y;
        collsion.w = data.w;
        collsion.h = data.h;
        collsion.r = data.r;
        collsion.collsionType = data.collsionType;
        collsion.collsionGroup = data.collsionGroup;
        collsion.owner = data.owner;
        collsion.owner.addChildAt(collsion, 0);
        collsion.vTime = vTime;
        collsion.damage = damage;
        this.collsionComArr.push(collsion);
        return collsion;
    }

    delCmop(comp: CollsionComp) {
        let index = this.collsionComArr.indexOf(comp);
        console.log('删除碰撞组件',comp,index)
        if (index >= 0) {
            comp && comp.owner && comp.owner.removeChild(comp);
            this.collsionComArr.splice(index, 1);
        }
    }

    updateCollsion() {
        let allCom = this.collsionComArr;
        for (let i = 0; i < allCom.length; i++) {
            if (allCom[i])
                allCom[i].updateCollsion()
        }
    }

    rectToRect(collsion1: CollsionComp, collsion2: CollsionComp) {
        
        let pos1 = collsion1.getWorldPos();
        let pos2 = collsion2.getWorldPos();
        let w1 = collsion1.w;
        let h1 = collsion1.h;
        let w2 = collsion1.w;
        let h2 = collsion1.h;
        let x1 = pos1.x;
        let y1 = pos1.y ;
        let x2 = pos2.x ;
        let y2 = pos2.y
        console.log("检测矩形碰撞-->>",x1,y1,x2,y2,w1,h1,w2,h2)
        if (Math.abs(x1 - x2) <= (w1 + w2)*0.5 && Math.abs(y1 - y2) <= (h1 + h2)*0.5) {
            return true;
        }
        return false;
    }


}