import { Anim, ANIM_TYPE } from "../Anim/Anim";
import Character from "../Character/Character";
import Healthy from "../Component/Healthy";
import HealthyUi from "../Component/HealthyUi";
import { COLLSION_GROUP, COLLSION_TYPE } from "../Enum/CollsionGroup";
import CollsionMgr from "../Manager/CollsionMgr";
import { CollsionComStuct } from "../Struct/CollsionComStruct";

export default class Enemy extends Character {
    healthCom:Healthy;
    healthUi:HealthyUi;
    constructor() {
        super();
    }

    initUi() {
        super.initUi();
        let anim: FYGE.FrameAni = Anim.animPool[ANIM_TYPE.ENEMY_IDLE];
        console.log('uauuaa-->', anim)
        this.addChild(anim);
        anim.play(0, null);
        anim.frameRate = 60;
        anim.scale.set(1.5, 1.5)
        this.curAnim = anim;
        let collsionData: CollsionComStuct = {
            x: 0,
            y: 95,
            w: 140,
            h: 150,
            collsionGroup: COLLSION_GROUP.ENEMY,
            collsionType: COLLSION_TYPE.RECT,
            owner: this
        }
        CollsionMgr.instance.setCollsionComp(collsionData)
        this.healthUi = new HealthyUi();
        this.addChild(this.healthUi);
        this.healthCom = new Healthy();
        this.healthCom.ui = this.healthUi;
        this.healthCom.maxHealth = 100;
        this.healthCom.curHealth = 100;
    }

    onHit(hitActor:Character,damge:number){
        super.onHit(hitActor,damge);
        this.healthCom.reduceHealth(damge)
        this.skewX = hitActor.scaleX* 5;
        FYGE.Tween.get(this).wait(500).call(()=>{this.skewX = 0})
        
    }
}