import Character from "../Character/Character";
import { COLLSION_GROUP, COLLSION_TYPE } from "../Enum/CollsionGroup";
import GameMgr from "../Manager/gameMgr";

export default class CollsionComp extends FYGE.Shape {
    private _w: number;
    private _h: number;
    private _x: number;
    private _y: number;
    private _r: number;
    private _collsionGroup: COLLSION_GROUP;
    private _collsionType: COLLSION_TYPE;
    private _owner: Character;

    set w(value) { this._w = value; }
    get w() { return this._w; }
    set y1(value) { this._y = value; }
    get y1() { return this._y; }
    set h(value) { this._h = value; }
    get h() { return this._h; }
    set x1(value) { this._x = value; }
    get x1() { return this._x; }
    set r(value) { this._r = value; }
    get r() { return this._r };
    set owner(value) { this._owner = value; }
    get owner() { return this._owner };
    set collsionGroup(value) { this._collsionGroup = value; }
    get collsionGroup() { return this._collsionGroup };
    set collsionType(value) { this._collsionType = value; this.debug(); }
    get collsionType() { return this._collsionType };

    getWorldPos() {
        let pos = { x: 0, y: 0 }
        pos.x = this.owner.x + this.owner.scaleX * this.x1;
        pos.y = this.owner.y + this.y1;
        return pos;
    }

    updateCollsion() {

    }

    debug() {
        if (!GameMgr.instance.isDebug) return;
        this.clear();
        switch (this.collsionType) {
            case COLLSION_TYPE.CIRCLE:
                this.beginFill(0x66ccff, 0.6)
                this.drawCircle(this.x1, this.y1, this.r);
                this.endFill();
                break;
            case COLLSION_TYPE.RECT:
                this.beginFill(0x66ccff, 0.6)
                this.drawRect(this.x1 - this.w * 0.5, this.y1 - this.h * 0.5, this.w, this.h);
                this.endFill();
                break;
        }
    }
}