import { Module } from "../../module/views/Module";
import { RES } from "../../module/RES";
import resCanvasList from "../../../game/resCanvasList"
import { GDispatcher } from "../Main";
import { MSG } from "../common/MyEvent";


export class Card extends Module {
    /**type:0：一般状态，1：正确状态，2：错误状态
     * size:0:大,1:中,2:小
     */
    constructor(data?: any) {
        super(data);
        this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, this.removeEvents, this)
    }

    id: number;
    isMoveCard: boolean = false;
    private size: number;
    private type: number;    //type:0：一般状态，1：正确状态，2：错误状态
    public cardImg: FYGE.Sprite;
    public changeStateEnd: boolean = false;
    private cardNormalUUidArr: string[];
    private cardTrueUUidArr: string[];
    private cardFalseUUidArr: string[];
    private rangeX: number;     //范围X
    private rangeY: number;     //范围Y
    private rangeW: number;     //范围宽
    private rangeH: number;     //范围高
    private moveLengthX:number;     //X轴一次移动的距离
    private moveLengthY:number;     //Y轴一次移动的距离
    private moveCnt: number;
    private moveDir: number = 0;    //移动方向:0：向右，1：向左，2：向上，3：向下
    private moveDuration:number = 500;     //每次移动所用的时间
    private changeStateDuration:number = 260;   //翻牌需要的时间
    private col:number;
    private row:number;
    isMoving: boolean = false;  //正在移动

    private isDebug:boolean = false;

    initUi() {
        var that = this;
        that.id = that.data.id;
        that.size = that.data.size;
        that.type = that.data.type;
        that.cardNormalUUidArr = ["5facc994-7d3a-4da8-9bf8-a2ceb7d2032e", "0c301127-1167-468f-8905-27cbd9d141d1", "5323f504-4a24-421a-9933-ef4064a5b8c0"];
        that.cardTrueUUidArr = ["7ce0d3de-cf71-495c-9c82-f75735f7ffd8", "1c69cf1a-b898-453d-b7a5-78ff638cf516", "abc359a6-ded8-4069-9da0-dbe93d78cf24"];
        that.cardFalseUUidArr = ["636340db-6418-4ca8-95bb-7b1930e8ced1", "e2d857f7-3bc0-417c-bd52-10da4d912786", "f1f23612-84f9-46a3-97f5-714def17f17f"];
        console.log("卡牌初始化啦")
        that.initCard();
        that.initEvents();
    }

    initCard() {
        var that = this;
        that.cardImg = new FYGE.Sprite();
        that.cardImg.mouseEnable = false;
        that.addChild(that.cardImg);
        if(that.isDebug&&that.type == 1){
            var label = new FYGE.TextField();
            label.text = "我是对的"
            label.size = 50;
            label.fillColor = "000"
            that.addChild(label);
            label.mouseEnable = false
        }
        that.setCardImgByType(that.type, true);
    }

    setCardImgByType(type: number, setAnchor = false) {
        var that = this;
        var texture;
        switch (type) {
            case 0:
                texture = RES.getRes(resCanvasList[that.cardNormalUUidArr[that.size]].url);
                break;
            case 1:
                texture = RES.getRes(resCanvasList[that.cardTrueUUidArr[that.size]].url);
                break;
            case 2:
                texture = RES.getRes(resCanvasList[that.cardFalseUUidArr[that.size]].url);
                break;
            default: console.error("卡片类型设置错误")
                break;
        }
        that.cardImg.texture = texture;
        if (setAnchor) {
            that.cardImg.anchorX = that.cardImg.width * 0.5;
            that.cardImg.anchorY = that.cardImg.height * 0.5;
        }
    }

    start(data) {
        super.start();
    }

    initEvents() {
        this.cardImg.addEventListener(FYGE.MouseEvent.CLICK, this.select, this)
        GDispatcher.addEventListener(MSG.GAMESTART_CHANGECARDSTATUS, this.setNorMalState, this);
        GDispatcher.addEventListener(MSG.GAMESTART_CARDMOVE, this.cardMove, this);
        GDispatcher.addEventListener(MSG.GAME_START, this.gameStart, this);
    }

    removeEvents() {
        this.cardImg.removeEventListener(FYGE.MouseEvent.CLICK, this.select, this)
        GDispatcher.removeEventListener(MSG.GAMESTART_CHANGECARDSTATUS, this.setNorMalState, this);
        GDispatcher.removeEventListener(MSG.GAMESTART_CARDMOVE, this.cardMove, this);
        GDispatcher.removeEventListener(MSG.GAME_START, this.gameStart, this);
    }

    gameStart(){
        this.cardImg.mouseEnable = true;
    }

    /**选择卡牌 */
    select() {
        console.log("选择卡牌")
        var that = this;
        this.parent.mouseChildren = false;
        FYGE.Tween.get(that.cardImg).to({ scaleX: 0 }, that.changeStateDuration).call(() => {
            if(that.type == 1){
                that.setCardImgByType(1)
            }
            else{
                that.setCardImgByType(2)
            }
        }).to({ scaleX: 1 }, that.changeStateDuration).call(() => {
            if(that.type == 1){
                that.mouseEnable = false;
                that.mouseChildren = false;
                console.log("选对啦")
                GDispatcher.dispatchEvent(MSG.GAME_SELETTRUE);
            }else{
                that.mouseEnable = false;
                that.mouseChildren = false;
                console.log("选错啦")
                GDispatcher.dispatchEvent(MSG.GAME_FAILED);
            }
            setTimeout(()=>{
                if(that&&that.parent){
                    that.parent.mouseChildren = true;
                }
            },100)
        })
    }

    /**变成一般状态 */
    setNorMalState() {
        var that = this;
        if (that.type == 1) {
            FYGE.Tween.get(that.cardImg).to({ scaleX: 0 }, that.changeStateDuration).call(() => {
                that.setCardImgByType(0)
            }).to({ scaleX: 1 }, that.changeStateDuration).call(() => {
                that.changeStateEnd = true;
                GDispatcher.dispatchEvent(MSG.GAMESTART_CHANGECARDPOS);
            })
        } else {
            that.changeStateEnd = true;
        }
    }

    /**卡牌移动 */
    cardMove() {
        // that.x <= (that.rangeX + that.rangeW) && that.x >= that.rangeX && that.y <= that.rangeY && that.y >= (that.rangeY + that.rangeH)
        var that = this;
        // if (!that.canMove) {
        if (that.isMoveCard) {
            // that.canMove = true;
            that.getDir();
        }
        // } else {
        //     that.getDir();
        // }
    }

    /**获取移动方向 */
    getDir() {
        var that = this;
        if (that.x == that.rangeX) {
            if (that.y == that.rangeY) {
                that.moveDir = 0;
            } else {
                that.moveDir = 2;
            }
        } else if (that.x == (that.rangeX + that.rangeW)) {
            if (that.y == (that.rangeY + that.rangeH)) {
                that.moveDir = 1;
            } else {
                that.moveDir = 3;
            }
        } else {
            if (that.y == that.rangeY) {
                that.moveDir = 0;
            } else if (that.y == that.rangeY + that.rangeH) {
                that.moveDir = 1;
            }
        }
        that.move();
    }

    /**移动 */
    move() {
        var that = this;
        that.isMoving = true;
        switch (that.moveDir) {
            case 0:     //右移动
                FYGE.Tween.get(that).to({x:that.x+that.moveLengthX},500).wait(50).call(()=>{
                    that.id++;
                    that.isMoving = false;
                    GDispatcher.dispatchEvent(MSG.GAMESTATR_CARDMOVEEND)
                })
                break;
            case 1:     //左移动
                FYGE.Tween.get(that).to({x:that.x-that.moveLengthX},500).wait(50).call(()=>{
                    that.isMoving = false;
                    that.id--;
                    GDispatcher.dispatchEvent(MSG.GAMESTATR_CARDMOVEEND)
                })
                break;
            case 2:     //上移动
                FYGE.Tween.get(that).to({y:that.y-that.moveLengthY},500).wait(50).call(()=>{
                    that.isMoving = false;
                    that.id -= that.col;
                    GDispatcher.dispatchEvent(MSG.GAMESTATR_CARDMOVEEND)
                })
                break;
            case 3:     //下移动
                FYGE.Tween.get(that).to({y:that.y+that.moveLengthY},500).wait(50).call(()=>{
                    that.isMoving = false;
                    that.id += that.col
                    GDispatcher.dispatchEvent(MSG.GAMESTATR_CARDMOVEEND)
                })
                break;
        }
    }

    /**改变当前卡牌状态 */
    changeState() {

    }

    /**设置移动范围与移动次数 */
    setMoveStatus(x: number, y: number, w: number, h: number, col:number,row:number,moveLengthX:number,moveLengthY:number) {
        var that = this;
        that.rangeX = x;
        that.rangeY = y;
        that.rangeW = w;
        that.rangeH = h;
        that.col = col;
        that.row = row;
        that.moveLengthX = moveLengthX;
        that.moveLengthY = moveLengthY;
    }

    /**获取卡片宽高 */
    getCardSize() {
        return { w: this.cardImg.width, h: this.cardImg.height }
    }
}