const imagemin = require('imagemin');
// const imageminJpegtran = require('imagemin-jpegtran');imagemin-mozjpeg
const imageminJpegtran = require('imagemin-mozjpeg');
const imageminPngquant = require('imagemin-pngquant');
var fs = require('fs');
var path = require('path');

// 要处理的图片文件夹路径
var altasPath = "./released/resource/"


var folders = getFolders(altasPath);
folders.map(async function (folder) {
    const files = await imagemin([altasPath + folder + '/*.{png,jpg}'], {
        destination: altasPath + folder,
        plugins: [
            imageminJpegtran(),
            imageminPngquant({
                quality: [0.6, 0.8]
            })
        ]
    });
    if (files && files.length) {
        files.forEach((v) => {
            console.log("压缩图片成功:", v.sourcePath.substring(v.sourcePath.lastIndexOf("/") + 1, v.sourcePath.length))
        })
    }
});


function getFolders(dir) {
    return fs.readdirSync(dir)
        .filter(function (file) {
            return fs.statSync(path.join(dir, file)).isDirectory();
        });
}