var fs = require("fs");

//类型对应
const DISRES = {
    'container': "Container",
    'text': "TextField",
    'button': "Button",
    'sprite': "Sprite",
    'rect': "Graphics",
    //  'skin'
}

const skinDataAll = JSON.parse(fs.readFileSync("./resource/skin.json"))
//取指令后的参数
let arg = process.argv.splice(2);
//类名
var className = arg[0];
//皮肤名字
var skinName = arg[0]; //arg[1];
//是否弹框，存在参数就是场景
var moduleType = className.indexOf("Scene") > -1 ? "Scene" : "Panel";
// console.log('类名:',className)
// console.log('皮肤名字:',skinName)

var skinData = getSkinDataByName(skinName, skinDataAll);
if (!skinData) {
    console.log(skinName + "皮肤不存在");
    return
}

var groupName = skinData.name;

var endPath = moduleType == "Panel" ? "./src/panels/" : "./src/scenes/";

// var ids = skinData.ids ? cutIds(skinData.ids) : ""

var template =
    (moduleType == "Panel" ?
        'import { Panel } from "../../module/views/Panel";\n' :
        'import { Scene } from "../../module/views/Scene";\n') +

    'export class ' + className + ' extends ' + moduleType + ' {\n' +

    '\tget groupNames() { return ["' + groupName + '"] }\n' +
    '\tget skinName() { return "' + skinName + '" }\n' +
    '\t' + getIds(skinData) + "\n" +
    '\tinitUi() {\n' +
    ' \n' +
    '\t}\n' +
    '\tstart(data) {\n' +
    '\t\tsuper.start();\n' +
    '\t}\n' +
    '\tinitEvents() {\n' +
    '\t\tsuper.initEvents();' +
    ' \n' +
    '\t}\n' +
    '\tremoveEvents() {\n' +
    '\t\tsuper.removeEvents();' +
    ' \n' +
    '\t}\n' +
    '}\n'

//取出skinName里的Item
var skins = getItemSkins(skinData)
if (skins.length) template = 'import { Item } from "../../module/views/Item";\n' + template;
for (var i = 0; i < skins.length; i++) {
    var skin = skins[i];
    template +=
        'class ' + upperCaseFirstChar(skin.name) + ' extends Item {\n' +
        '\tget skinName() { return "' + skin.name + '" }\n' +
        '\t' + getIds(skin) + "\n" +
        '\tinitUi(data?) {\n' +
        ' \n' +
        '\t}\n' +
        '\tupdateData(data?) {\n' +
        ' \n' +
        '\t}\n' +
        '\tinitData(id: number, data: any): void {\n' +
        '\t\tsuper.initData(id,data);\n' +
        ' \n' +
        '\t}\n' +
        '\tresetData() {\n' +
        ' \n' +
        '\t}\n' +
        '}\n'
}


fs.writeFileSync(endPath + className + ".ts", template)

// function cutIds(ids) {
//     var str = ''
//     var arr = ids.split(";")
//     // console.log(arr)
//     arr.forEach(element => {
//         if (element) str += element + ";\n\t"
//     });
//     return str
// }
/**
 * 获取皮肤数据
 * @param {*} skinName
 * @param {*} skinNode
 */
function getSkinDataByName(skinName, skinNode) {
    if (!skinNode || !skinNode.children || !skinNode.children.length) return null;
    for (var i = 0; i < skinNode.children.length; i++) {
        var child = skinNode.children[i];
        if (child.name == skinName && (child.type == "container" || child.type == "skin")) return child;
        var gson = getSkinDataByName(skinName, child);
        if (gson) return gson
    }
    return null;
}

//取出所有的
function getItemSkins(skinNode) {
    var arr = []
    for (var i = 0; i < skinNode.children.length; i++) {
        var c = skinNode.children[i];
        if (c.type == 'skin') arr.push(c);
    }
    return arr
}



function getIds(skinNode, str) {
    str = str || ''
    for (var i = 0; i < skinNode.children.length; i++) {
        var c = skinNode.children[i];
        if (c.id) str += c.id + ":FYGE." + DISRES[c.type] + ";\n\t";
        if (c.type == "container" && c.type != "skin") str = getIds(c, str);
    }
    return str
}

function upperCaseFirstChar(str) {
    return str.charAt(0).toUpperCase() + str.slice(1)
}
