var fs = require('fs');
var path = require('path');
const co = require('co');
const OSS = require('ali-oss');

const chalk = require('chalk');
const ProgressBar = require('progress');

class TuiaAutoUpload {
    constructor(props, type) {
        this.type = type;
        const defaultOptions = {
            dir: undefined,
            originDir: undefined
        }
        this.options = Object.assign({}, defaultOptions, props);
        if (!this.options.dir || !this.options.originDir) {
            console.log(chalk.red('缺少参数，初始化失败'))
            return;
        }
        this.init();
    }
    init() {
        var _this = this;
        this.client = new OSS({
            region: 'oss-cn-hangzhou',
            accessKeyId: 'LTAI4Fw25WcfcGv7FvcHoiHK',
            accessKeySecret: 'NZk1NtT9J5HFaAolNbtQdzTzLLvLYm',
            bucket: _this.type === 'prod' ? 'duiba' : 'daily-duiba'
        });
        this.bar = new ProgressBar(chalk.yellow(`  文件上传中 [:bar] :current/${this.files().length} :percent :elapseds`), {
            complete: '●',
            incomplete: '○',
            width: 20,
            total: this.files().length,
            callback: () => {
                console.log(chalk.green('\n  All complete.'));
                console.log(chalk.blue(`\n  本次队列文件共${this.files().length}个，已存在文件${this.existFiles}个，上传文件${this.uploadFiles}个，上传失败文件${this.errorFiles}个\n`));
            }
        })
        return this;
    }
    files() {
        var _this = this;
        if (this._files) return this._files;
        this._files = [];

        /**
         * 文件遍历方法
         * @param filePath 需要遍历的文件路径
         */
        function fileDisplay(filePath) {
            //根据文件路径读取文件，返回文件列表
            var files = fs.readdirSync(filePath);
            files.forEach(function (filename) {
                //获取当前文件的绝对路径
                var filedir = path.join(filePath, filename);
                //根据文件路径获取文件信息，返回一个fs.Stats对象
                var stats = fs.statSync(filedir);
                var isFile = stats.isFile();//是文件
                var isDir = stats.isDirectory();//是文件夹
                if (isFile) {
                    var sep = '/';
                    if ('win32' == process.platform)
                        sep = '\\';
                    var newDirArr = filedir.split(sep);
                    newDirArr.shift();
                    _this._files.push(newDirArr.join('/'));
                }
                if (isDir) {
                    fileDisplay(filedir);//递归，如果是文件夹，就继续遍历该文件夹下面的文件
                }
            });

        }

        //调用文件遍历方法
        fileDisplay(this.options.dir);
        return this._files;
    }
    start() {
        this.files().map((file, index) => {
            let _this = this;
            const path1 = path.join(path.resolve(__dirname, '..'), 'released', file);
            let originFile;
            this.existFiles = 0;
            this.uploadFiles = 0;
            this.errorFiles = 0;
            co(function* () {
                const originPath = `${_this.options.originDir}${file}`;
                try {
                    originFile = yield _this.client.head(originPath);
                } catch (error) {
                    originFile = error;
                }
                if (_this.type === 'prod') {
                    if (originFile.status === 404) {
                        yield _this.client.put(originPath, path1);
                        _this.uploadFiles += 1;
                    } else {
                        _this.existFiles += 1;
                    }
                } else if (_this.type === 'dev') {
                    if (originFile.status === 404 || originFile.status === 200) {
                        _this.existFiles += 1;
                    }
                    yield _this.client.put(originPath, path1, {
                        headers: {
                            'Cache-Control': 'no-cache'
                        }
                    })
                    _this.uploadFiles += 1;
                }
                _this.bar.tick();
            }).catch(function (err) {
                _this.errorFiles += 1;
                console.log(err);
            });
        });
    }
}

const configFileName = 'project.json';
if (!fs.existsSync(configFileName)) {
    throw new Error(`${configFileName}不存在.`)
}
let config = fs.readFileSync('project.json');
config = JSON.parse(config + '');
if (!config.type) {
    throw new Error(`${configFileName}的type不存在.`)
}

if (!config.name) {
    throw new Error(`${configFileName}的name不存在.`)
}

const now = new Date();
const version = Math.round(now.getTime() / 1000);
console.log(`版本号：
    ${version}`)

const autoupload = new TuiaAutoUpload({
    dir: './released/',
    // dir: path.join(__dirname, './released/'),
    originDir: `/db_games/${config.type}/${config.name}/${version}/`
}, "prod")

autoupload.start()

var iconv = require('iconv-lite');
var readPath = "./released/resource/";
//读取json文件
var data = iconv.decode(fs.readFileSync(readPath + "res.json"), "utf-8");//GBK
//反序列化
data = JSON.parse(data);
data.path = `https://yun.duiba.com.cn/db_games/${config.type}/${config.name}/${version}/resource/`
//写入目标文件夹，可配置，每个项目必须修改，或者直接和project的保持一致（淘宝项目文件固定后）
var endPath = './src/';
var endFile = `export const ResJson = ${JSON.stringify(data, "", "\t")}`
fs.writeFileSync(endPath + "ResJson.ts", endFile);