import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";
import {getTexture, vectorUnit} from "../utils"
import { EnemyBulletManager } from "../Manager/EnemyBulletManager";
import { LayerManager } from "../Manager/LayerManager";
import { GameManager } from "../Manager/GameManager";
import { EffectManager } from "../Manager/EffectManager";
import { Ins } from "../../Ins";

export class BuleBoss extends BaseEnemy {
    constructor(){
        super();
    }

    addToViewPort(){
        super.addToViewPort();
        this.setBody("51568410-82e7-4f2c-86cb-0040ffced1b9");
        this.hitW = 320;
        this.hitH = 130;
        this.x = Ins.stageW*0.5 - this.bodyImg.width*0.5;
        this.y = -this.bodyImg.height;
        this.enemyType = enemyType.boss;
        this.changeState(enemyState.goStage);
        this.curSkillMax = 1;
        this.health = 200
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=(that.bodyImg.height*0.1)){
                    that.changeState(enemyState.wait);
                }
            break;
            case enemyState.inSatge:
                that.worldTime++;
                that.horizonBounds();
                if(that.worldTime%90==0){
                    that.worldTime = 0;
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.wait:
                that.worldTime++;
                if(that.worldTime%90 == 0){
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.attack:
                that.horizonBounds();
                switch(that.curSkillIndex){
                    case 0:
                        that.createDartBullet();
                        break;
                    case 1:
                        that.createLaser();
                        break;
                }
                break;
        }
    }



    changeState(state:enemyState){
        switch(state){
            case enemyState.goStage:
                this.speedY = 2;
                this.speedX = 0;
                this.speedVector.x = 0;
                this.speedVector.y = 1;
                break;
            case enemyState.inSatge:
                this.bossSetInStage();
                break;
            case enemyState.attack:
                this.curSkillIndex++;
                if(this.curSkillIndex>this.curSkillMax)
                    this.curSkillIndex = 0;
                break;
        }
        this.enemyState = state;
    }
}