import { Ins } from "../../Ins";
import { BaseEnemy, enemyType } from "./BaseEnemy";

export class Blue extends BaseEnemy{
    dir:number;
    constructor(x:number,y:number,dir:number){
        super();
        this.x = x;
        this.y = y;
        this.dir = dir;
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("decd3f0d-860f-4a5c-ac46-38b80f3aa043");
        that.bodyImg.anchorX = that.bodyImg.width*0.5;
        that.bodyImg.anchorY = that.bodyImg.height*0.5;
        that.hitW = 70;
        that.hitH = 40;
        that.health = 10;
        that.enemyType = enemyType.normal;
        if(that.dir<0){     //从左边飞出
            that.bodyImg.rotation = -90;
            that.speedX = 12;
            that.speedVector.x = 1;
            that.speedY = 8
        }else{      //从右边飞出
            that.bodyImg.rotation = 90;
            that.speedX = 12;
            that.speedVector.x = -1;
            that.speedY = 8;
        }
    }

    updateSelf(){
        var that = this;
        super.updateSelf();
        
        if(that.dir<0){
            if(that.x>=Ins.stageW*3/4){
                that.speedVector.x = 0;
            }
            if(that.x>(Ins.stageW/4-50)){
                if(that.bodyImg.rotation<0)
                    that.bodyImg.rotation += 2.5;
                else
                    that.bodyImg.rotation = 0;
                that.speedVector.y = 1;
            }
        }else{
            if(that.x<=(Ins.stageW/4-50)){
                that.speedVector.x = 0;
            }
            if(that.x<Ins.stageW*3/4){
                if(that.bodyImg.rotation>0)
                    that.bodyImg.rotation -= 2.5;
                else
                    that.bodyImg.rotation = 0;
                that.speedVector.y = 1;
            }
        }
    }
}