import { Ins } from "../../Ins";

export class LayerManager
{
    private static _ins:LayerManager = null;
    static get Ins(){
        if(!this._ins){
            this._ins = new LayerManager();
        }
        return this._ins;
    }

    bgLayer:FYGE.Sprite;
    enemyLayer:FYGE.Sprite;
    playerLayer:FYGE.Sprite;
    bulletLayer:FYGE.Sprite;
    buffLayer:FYGE.Sprite;
    effectLayer:FYGE.Sprite;
    touchLayer:FYGE.Shape;
    uiLayer:FYGE.Sprite;

    initLayer(view:FYGE.Container){
        var that = this;
        that.bgLayer = new FYGE.Sprite();
        view.addChild(that.bgLayer);
        that.enemyLayer = new FYGE.Sprite();
        view.addChild(that.enemyLayer);
        that.playerLayer = new FYGE.Sprite();
        view.addChild(that.playerLayer);
        that.bulletLayer = new FYGE.Sprite();
        view.addChild(that.bulletLayer);
        that.buffLayer = new FYGE.Sprite();
        view.addChild(that.buffLayer);
        that.effectLayer = new FYGE.Sprite();
        view.addChild(that.effectLayer);

        // that.touchLayer = new FYGE.Shape();
        // that.touchLayer.mouseEnable = true;
        // that.touchLayer.mouseChildren = true;
        // that.touchLayer.beginFill(1,0.01);
        // that.touchLayer.drawRect(0,0,Ins.stageW,Ins.stageH);
        // that.touchLayer.endFill();
        // that.touchLayer.width = Ins.stageW;
        // that.touchLayer.height = Ins.stageH;
        // view.addChild(that.touchLayer);

        that.uiLayer = new FYGE.Sprite();
        that.uiLayer.mouseEnable = false;
        view.addChild(that.uiLayer);
    }
}