export class BaseSprite extends FYGE.Sprite{
    listenerArr:any[] = [];
    constructor(){
        super();
        this.init();
        this.addEventListener(FYGE.Event.ADDED_TO_STAGE,this.addToViewPort,this);
        this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE,this.removeFromViewPort,this);
    }

    init(){

    }

    addToViewPort(){
        this.removeEventListener(FYGE.Event.ADDED_TO_STAGE,this.addToViewPort,this)
    }

    removeFromViewPort(){
        FYGE.Tween.removeTweens(this);
        this.removeEventListener(FYGE.Event.REMOVED_FROM_STAGE,this.removeFromViewPort,this);
        for(var i=0;i<this.listenerArr.length;i++){
            var data = this.listenerArr[i];
            data.obj.removeEventListener(data.type,data.listener,data.context,data.useCapture);
        }
    }

    addListener(obj:any,type: string, listener: Function, context?: any, useCapture?: boolean){
        var data = {
            obj:obj,
            type:type,
            listener:listener,
            context:context,
            useCapture:useCapture
        }
        this.listenerArr.push(data);
        obj.addEventListener(type,listener,context,useCapture)
    }

    removeListener(obj:any,type: string, listener: Function, context?: any, useCapture?: boolean){
        for(var i=0;i<this.listenerArr.length;i++){
            if(this.listenerArr[i].obj==obj&&this.listenerArr[i].type == type){
                this.listenerArr.splice(i,1);
                break;
            }
        }
        obj.removeEventListener(type,listener,context,useCapture);
    }
}