import { RES } from "../module/RES";
import { layers, destroyLayers } from "../module/views/layers";
import { ResJson } from "./ResJson";
import { G_EVENT } from "./common/G_EVENT";
import { destroyAllCtrls, changeScene, showToast } from "../module/ctrls";
import { StartScene } from "./scenes/StartScene";
import { destroyNetData } from "./TaoBaoNet";


import resCanvasList from '../resCanvasList';
import { MainScene } from "./scenes/mainScene";
import { Ins } from "./Ins";


/**
 * 全局事件，为了和小程序交互
 * 有可能多处页面用到，所以单开
 */
export const GDispatcher = new FYGE.EventDispatcher();

export class Main {
    //主舞台
    stage: FYGE.Stage;
    private requestID;
    private _pause: boolean;
    constructor(canvas: HTMLCanvasElement) {
        var sysInfo;
        //@ts-ignore 存在my就初始化
        if (my) {
            FYGE.initedByCanvas(canvas)

            //@ts-ignore 存在my就初始化
            sysInfo = my.getSystemInfoSync()
        }
        //建舞台
        var stage = new FYGE.Stage(
            canvas,
            750,//设计宽度，按设计搞给的就行
            1624,//设计高度
            sysInfo && sysInfo.windowWidth || document.body.clientWidth,
            sysInfo && sysInfo.windowHeight || document.body.clientHeight,
            FYGE.RENDERER_TYPE.WEBGL
        );
        this.stage = stage;
        //开始循环
        // FYGE.Stage.flushAll();
        //stage初始化
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        //帧率
        // var stats = new FYGE.Stats("canva4stats");
        //循环
        var self = this;
        // console.log(FYGE)
        loop();
        function loop() {
            if (!self._pause) {
                // stats.begin();
                FYGE.Tween.flush()
                stage.flush();
                // stats.end();
            }
            //@ts-ignore
            self.requestID = FYGE.getRequestAnimationFrame()(loop);
        }
    }

    private async onAddToStage() {
        Ins.stageW = this.stage.viewRect.width;
        Ins.stageH = this.stage.viewRect.height;
        //初始化层级
        layers.init(this.stage);
        console.log("初始化层级完成")
        //初始化资源配置
        // RES.loadConfig(ResJson);
        // console.log("初始化资源配置完成")
        //皮肤配置加载
        // RES.loadSkinConfig(SkinJson);
        //加载通用资源
        // await RES.loadGroup("common");
        await RES.loadSparkAssets(resCanvasList).catch(r=>{
            console.log("通用资源加载失败")
        });
        console.log("通用资源加载完成")
         //打开开始场景
        changeScene(MainScene);
        // showToast("aaaaa")
        // changeScene(LoadingScene);
        // changeScene(SStartScene);
        // changeScene(StoryScene);
        // changeScene(AdoptScene);
        // console.log("恶趣味去")
        // showPanel(NoStepPanel)
        //测试
        // sendTbNet(TbNetName.aaa, {}, (s, res) => {
        //     console.log(res)
        // })
        //获取数据,，必成功
        // showWaiting();
        // sendTbNet(TbNetName.getAppData, {}, (s, res) => {
        //     hideWaiting();
        //     Tool.globalData = res.data;
        //     changeScene(PlayScene);
        //     //先去获取下任务列表的商品信息吧
        //     sendTbNet(TbNetName.getTaskList, { activityId: Tool.globalData.activityId }, (s, res) => {
        //         if (s) Tool.browseItems = res.data.browseItemIds.content;
        //     })
        // })
    }

    //在小程序显示时调用onShow
    run() {
        this._pause = false
        //@ts-ignore Tween计时清零
        // FYGE.Tween._lastTime = null  //下面的_pause 不执行，先去掉，试试有没有问题

        GDispatcher.dispatchEvent(G_EVENT.ON_SHOW);
    }
    //在小程序隐藏时调用onHide
    pause() {
        // this._pause = true;//先去掉吧
        GDispatcher.dispatchEvent(G_EVENT.ON_HIDE);
    }

    /**
     * 添加全局事件，用于小程序的交互调用
     * 一直很犹豫要不要放在main的实例里，还是和Main同级导出，还有上面的pause，run，下面的事件等
     * @param name
     * @param fun
     * @param thisObj
     */
    addGlobalEvent(name: string, fun: Function, thisObj?: any, once: boolean = false) {
        if (once) {
            GDispatcher.once(name, fun, thisObj)
        } else {
            GDispatcher.addEventListener(name, fun, thisObj)
        }
    }
    /**
     * 派发全局事件，用于小程序的交互调用
     * @param name 可以是事件名，也可以是事件
     * @param data
     */
    dispatchGlobalEvent(name: string | any, data?: any) {
        GDispatcher.dispatchEvent(name, data)
    }
    /**
     * 移除全局事件，用于小程序交互调用
     * @param name
     * @param fun
     * @param thisObj
     */
    removeGlobalEvent(name: string, fun: Function, thisObj?: any) {
        GDispatcher.removeEventListener(name, fun, thisObj)
    }


    //在小程序页面卸载时调用onUnload，多次销毁后会有问题，再检查
    destroy() {
        //Tween都移除，注意吧，可能原先的也被移除
        FYGE.Tween.removeAllTweens()
        // removeAllTimeoutId();//这个再看，尽量用tween的修改
        //停掉计时器
        FYGE.getCancelAnimationFrame()(this.requestID);
        //层级销毁
        destroyLayers()
        //销毁控制器
        destroyAllCtrls();
        //舞台销毁
        this.stage.destroy();
        //全局事件置空
        GDispatcher.removeAllEventListener();
        //网络数据记录清空
        destroyNetData();
    }
}




