import { BaseEnemyBullet } from "./BaseEnemyBullet";
import { getTexture } from "../utils";
export class DartBullet extends BaseEnemyBullet{
    constructor(x:number,y:number,speed:number,vector:FYGE.Point){
        super();
        this.x = x;
        this.y = y;
        this.speedX = this.speedY = speed;
        this.speedVector = vector;
    }

    addToViewPort(){
        super.addToViewPort();
        this.bodyImg.texture = getTexture("ac1ce869-60e4-4488-a80c-8bd8f03a7d64");
        this.bodyImg.x = -this.bodyImg.width>>1;
        this.bodyImg.y = -this.bodyImg.height>>1;
    }

    updateSelf(){
        this.rotation+=5;
        super.updateSelf();
    }
}
