import { Ins } from "../../Ins";
import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";

export class BlueElite extends BaseEnemy{
    constructor(){
        super();
    }
    canShot = true;
    
    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("70ad9c6f-267f-4adf-9b7a-fb97f4a72a21");
        that.hitW = 160;
        that.hitH = 80;
        that.health = 30;
        that.speedVector.y = 1;  
        that.speedY = 3;
        that.y = -105;
        that.worldTime = 40;
        that.x = Ins.stageW*0.5 - that.bodyImg.width*0.5;
        that.enemyType = enemyType.elite;
        that.enemyState = enemyState.goStage;
    }

    updateSelf(){
        var that = this;
        super.updateSelf();
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=300){
                    that.speedVector.y = 0;
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                if(that.worldTime%100==0){
                    that.worldTime =0;
                    that.changeState(enemyState.attack)
                }   
                break;
            case enemyState.attack:
                that.createGrapThreeSword();
                break;
        }
        
    }

    changeState(state:enemyState){
        this.enemyState = state;
    }
}