import { Ins } from "../Ins";
import { BaseSprite } from "./BaseSprite";
import { GameManager } from "./Manager/GameManager";
import { getTexture } from "./utils";

export class PointUi extends BaseSprite{

    maxPointLabel:FYGE.TextField;
    curPointLabel:FYGE.TextField;
    curPointBg:FYGE.Sprite;
    breakRecordImg:FYGE.Sprite;
    isBreak:boolean = false;

    constructor(data?:any){
        super();
        if(data){
            GameManager.INS.playerMaxScore = data.maxPoint;
            GameManager.INS.playerScore = data.curPoint;
        }
    }

    init(){
        var that = this;
        that.y = 60;

        let maxPointLabel1 = new FYGE.TextField();
        that.addChild(maxPointLabel1);
        that.curPointBg = new FYGE.Sprite(getTexture("1dca3d22-45ef-4e34-a9d9-8eb9f717d4bc"));
        that.addChild(that.curPointBg);
        that.curPointBg.y = 50;
        let curPointLabel1 = new FYGE.TextField();
        that.curPointBg.addChild(curPointLabel1);
        maxPointLabel1.fillColor = "#fef33f";
        maxPointLabel1.text = "最高分：";
        curPointLabel1.fillColor = "#fac42f";
        curPointLabel1.text = "本局得分："
        maxPointLabel1.size = curPointLabel1.size = 18;
        curPointLabel1.y = (that.curPointBg.height - maxPointLabel1.textHeight)*0.5

        that.x = Ins.stageW - that.curPointBg.width;

        that.maxPointLabel = new FYGE.TextField();
        that.addChild(that.maxPointLabel);
        that.curPointLabel = new FYGE.TextField();
        that.curPointBg.addChild(that.curPointLabel);
        that.maxPointLabel.fillColor = "#fef33f";
        that.curPointLabel.fillColor = "#fac42f";
        that.maxPointLabel.size = that.curPointLabel.size = 18;
        that.curPointLabel.y = curPointLabel1.y;

        that.breakRecordImg = new FYGE.Sprite(getTexture("9cf1e8fe-6d63-4442-a42e-c9605bb2727f"));
        that.addChild(this.breakRecordImg);
        that.breakRecordImg.x = that.curPointBg.x;
        that.breakRecordImg.y = that.curPointBg.y + that.curPointBg.height +20;
        that.breakRecordImg.anchorX = that.breakRecordImg.width >>1;
        that.breakRecordImg.visible = false;
    }

    updateLabel(){
        var that = this;
        that.maxPointLabel.text = GameManager.INS.playerMaxScore+'';
        that.curPointLabel.text = GameManager.INS.playerScore+'';
        that.maxPointLabel.x = that.curPointBg.width - that.maxPointLabel.textWidth-10;
        that.curPointLabel.x = that.curPointBg.width - that.curPointLabel.textWidth-10;
    }

    breakRecord(){
        var that = this;
        if(GameManager.INS.isBreak) return;
        GameManager.INS.isBreak = true;
        that.breakRecordImg.scaleX = that.breakRecordImg.scaleY = 0;
        that.breakRecordImg.visible = true;
        FYGE.Tween.get(that.breakRecordImg).to({scaleX:1,scaleY:1},150).wait(500).to({scaleX:0,scaleY:0},150).call(()=>{that.breakRecordImg.visible = false;})
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.maxPointLabel.text = GameManager.INS.playerMaxScore+'';
        that.maxPointLabel.x = that.curPointBg.width - that.maxPointLabel.textWidth-10;
        that.curPointLabel.text = GameManager.INS.playerScore+'';
        that.curPointLabel.x = that.curPointBg.width - that.curPointLabel.textWidth-10;
    }
}