/**
 * Created by rockyl on 2020/10/13.
 *
 * @id porjectx
 * @name 星速台相关的过程
 * @desc 星速台相关的过程
 */

/**
 * @type 1
 * @name 获取token
 * @desc 获取星速台防刷token
 * @outputs {success:'成功:响应内容', failed:'失败:错误信息'}
 */
export function getPxToken() {
	return new Promise(resolve => {
		if (location.href.indexOf('.com.cn/projectx') < 0) {  //本地环境测试
			resolve({
				type: 'success',
				payload: {
					token: 'test_token'
				}
			})
		} else {
			window.getPxToken((e, token) => {
				if (e) {
					resolve({
						type: 'failed',
						payload: e,
					})
				} else if (!token) {
					resolve({
						type: 'failed',
						payload: new Error('empty token')
					})
				} else {
					resolve({
						type: 'success',
						payload: {
							token
						}
					})
				}
			});
		}
	})
}
