/**
 * 根据路径记录
 */
export const soundHash={};

export function cusPlaySound(src, loop = false) {
    return playSound(src, loop);
}

/**
 * 提前加载音频
 * @param type
 */
export function preloadSound(src) {
    soundHash[src] = new Howl({
        src: src,
        preload: true,
    });
}


export function playSound(src, loop = false) {
    let sound;
    //循环的，且有缓存，取缓存的
    if (soundHash[src] && loop) sound = soundHash[src]
    //没有就新建
    if (!sound) sound = new Howl({ src: [src], autoplay: false, loop });
    //记录下，方便停止
    soundHash[src] = sound;
    //不循环删除缓存
    if (!loop) sound.on('stop', function () { delete soundHash[src] });
    //播放
    sound.play();
    //返回一个，可以自行控制
    return sound;
}

export function stopSound(src) {
    if (soundHash[src]) soundHash[src].stop();
}

export function stopAllSound() {
    for (let key in soundHash) soundHash[key].stop();
}

export function playAllSound() {
    for (let key in soundHash) soundHash[key].play();
}


//设置隐藏属性和改变可见属性的事件的名称
let hidden, visibilityChange;
if (typeof document.hidden !== 'undefined') {
    hidden = 'hidden';
    visibilityChange = 'visibilitychange';
} else if (typeof document['msHidden'] !== 'undefined') {
    hidden = 'msHidden';
    visibilityChange = 'msvisibilitychange';
} else if (typeof document['webkitHidden'] !== 'undefined') {
    hidden = 'webkitHidden';
    visibilityChange = 'webkitvisibilitychange';
}

const handleVisibilityChange = (e) => {
    if (document.visibilityState == "visible") {
        playAllSound();
        console.log("网页显示")
    }
    else if (document.visibilityState == "hidden") {
        stopAllSound()
        console.log("网页隐藏")
    }
};

document.addEventListener(
    visibilityChange,
    handleVisibilityChange,
    false
);

window.onbeforeunload = function () {
    //发接口
}