/**
 * Created by rockyl on 2020/9/19.
 */

import {Sprite, Point, TextureCache} from 'fyge'

export class RedPack extends Sprite {
	constructor() {
		super();

		this._pos = new Point();
		this._globalPos = new Point();
	}

	get pos() {
		return this._pos;
	}

	get globalPos() {
		return this._globalPos;
	}

	init(data) {
		this.data = data;

		const {source, initPos, type} = data;
		this.type = type;

		this.texture = TextureCache[source];

		this.x = this._pos.x = initPos;
		this.y = this._pos.y = -this.height;
	}

	schedule() {
		const {width, height, data: {angleOffset, speed}} = this;

		let radian = (angleOffset + 90) * Math.PI / 180;

		let speedX = Math.cos(radian) * speed;
		let speedY = Math.sin(radian) * speed;

		this.x = this._pos.x += speedX;
		this.y = this._pos.y += speedY;

		this.parent.localToGlobal(this._pos, this._globalPos);
		const {_globalPos: {x, y}} = this;
		if (y < -height || y > this.stage.stageHeight) {
			return true;
		}
		if (angleOffset > 0) {
			if (x < -width) {
				return true;
			}
		} else if (angleOffset < 0) {
			if (x > this.stage.width) {
				return true;
			}
		}
	}
}
