import {
    Event,
    Sprite,
    TextureCache,
    WidgetBase,
    injectProp,
    TextField,
    TEXT_ALIGN,
    Shape,
    MouseEvent,
    Point,
    GDispatcher,
    Tween,
    MovieClip
} from "fyge";
import {
    Car
} from "./car";
import {
    GameStage
} from "./GameStage";
import {
    Ins,
    getRandomValue,
    OBB,
    vector,
    detectorOBBvsOBB,
    loadSvgaList
} from "./Ins";
import * as SvgaParser from "svga-parser";
import { LoadSvga } from "./LoadSvga";
import { ScoreTips } from "./ScoreTips";

export class CornerRacingWidget extends WidgetBase {

    gameBg;
    gameGroup;
    gameUi;
    lastLevelLabel;
    nextLevelLabel;
    scoreLabel;
    levelProgress;
    levelProgressBg;
    curScore;
    curLevel;

    maxCarCnt = 10;
    goneCarCnt;
    curPlayerCarL;
    playerCarInitOver = false;
    isChangeDir = false;

    gameState = 0; //游戏状态，0：暂停，1：运行

    trackTime1; //赛道1的经过时间
    trackTime2; //赛道2的经过时间
    trackInitTime1; //赛道1的出车时间
    trackInitTime2; //赛道2的出车时间
    randomInitTime; //随机出车的时间段

    trackCarArr1 = []; //赛道1的车辆         
    trackCarArr2 = []; //赛道2的车辆
    turningCar = []; //当前在拐弯的玩家车辆
    playerCarArr = []; //玩家车辆组

    levelInfo = [];



    constructor() {
        super();
        this.addEventListener(Event.ADDED_TO_STAGE, this.addToViewPort, this)
        this.addEventListener(Event.REMOVED_FROM_STAGE, this.removeFromViewPort, this);

    }

    addToViewPort() {
        this.removeEventListener(Event.ADDED_TO_STAGE, this.addToViewPort, this)
        // setTimeout(() => {
        //     // this.initUi();
        //     this.dispatchOutEvent('initOver')
        // }, 1500)
    }

    removeFromViewPort() {
        // this.parent.removeChild(this);
        // for(let i=0;i<this.children.length;i++){
        //     this.removeChild(this.children[i]);
        //     i--;
        // }
        if(this&&this.parent)
            this.parent.removeChild(this);
        // GDispatcher.dispatchEvent(Event.REMOVED_FROM_STAGE)
        // console.log("ewwefwefwefewf");
        this.removeEventListener(Event.REMOVED_FROM_STAGE, this.removeFromViewPort, this);
        this.removeEventListener(Event.ENTER_FRAME, this.onEnterFrame, this);
        // this.stage.removeEventListener(MouseEvent.MOUSE_DOWN, this.carTurning, this);
        GDispatcher.removeEventListener(Ins.msg.trackTurnOver, this.tackTurnOverHandler, this);
        GDispatcher.removeEventListener(Ins.msg.vipStartTurn,this.vipCarTurning,this);
    }

    initUi() {
        Ins.stageW = this.stage.viewRect.width;
        Ins.stageH = this.stage.viewRect.height;
        // console.log("舞台高",Ins.stageh)
        Ins.normalCarArr = this.props.normalCar;
        Ins.vipCarArr = this.props.vipCar;
        this.curPlayerCarL = true;
        this.trackTime1 = 0;
        this.trackTime2 = 0;
        this.randomInitTime = [30, 80];
        this.trackInitTime1 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
        this.trackInitTime2 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
        this.trackTime1 = this.trackInitTime1 - 1;
        this.trackTime2 = this.trackInitTime2 - 1
        this.levelInfo = this.props.levelInfo;
        // console.log(Ins.normalCarArr, Ins.vipCarArr)

        // SvgaParser.loadSvga(
        //     "https://yun.duiba.com.cn/spark/assets/46b86276f0d04b34d50d98a852b9ee9ffd0d6f03.svga",
        //     (v) => {
        //         this.addChild(new MovieClip(v));
        //     },
        //     (err) => {
        //         console.log(err)
        //     }
        // )
        if(this.curLevel>Ins.maxLevel){
            /**通关 */
            this.gameClear();
            return;
        }
        // console.log("insss",Ins.trackCarArr1)
        for (let i = 0; i < Ins.trackCarArr1.length; i++) {
            Ins.trackCarArr1[i].parent.removeChild(Ins.trackCarArr1[i]);
            Ins.trackCarArr1.splice(i, 1);
            i--;
        }
        
        for (let i = 0; i < Ins.trackCarArr2.length; i++) {
            Ins.trackCarArr2[i].parent.removeChild(Ins.trackCarArr2[i]);
            Ins.trackCarArr2.splice(i, 1);
            i--;
        }

        for (let i = 0; i < this.playerCarArr.length; i++) {
            this.gameGroup.removeChild(this.playerCarArr[i]);
            this.playerCarArr.splice(i, 1);
            i--;
        }

        for (let i = 0; i < this.turningCar.length; i++) {
            this.gameGroup.removeChild(this.turningCar[i]);
            this.turningCar.splice(i, 1);
            i--;
        }
        
        this.goneCarCnt = 0;

        this.initConfig();
        this.initGameMap();
        this.initGameUi();
        this.initNewLevel();
        this.addEvent();
        this.start();
    }

    initConfig() {
        this.curLevel = 1;
        this.curScore = 0;
        this.goneCarCnt = 0;
    }

    initGameMap() {
        this.gameGroup = new Sprite();
        this.addChild(this.gameGroup);
        this.gameBg = new Sprite(TextureCache["807ec201-9341-40f4-b32a-721c337ad81c"]);
        this.gameGroup.addChild(this.gameBg);

        Ins.effectLayer = new Sprite();
        this.gameGroup.addChild(Ins.effectLayer);
    }

    initGameUi() {
        this.gameUi = new Sprite(TextureCache["c2df98d5-8fa6-4e17-a3bd-9440be05f33d"]);
        this.addChild(this.gameUi);
        this.gameUi.x = Ins.stageW * 0.5 - this.gameUi.width * 0.5;
        this.gameUi.y = 52;

        //关卡标识初始化
        {
            this.lastLevelLabel = new TextField();
            this.gameUi.addChild(this.lastLevelLabel);
            this.nextLevelLabel = new TextField();
            this.gameUi.addChild(this.nextLevelLabel);
            this.lastLevelLabel.size = this.nextLevelLabel.size = 24;
            this.lastLevelLabel.textWidth = this.nextLevelLabel.textWidth = 80;
            this.lastLevelLabel.textAlign = this.nextLevelLabel.textAlign = TEXT_ALIGN.CENTER;
            this.lastLevelLabel.text = this.curLevel >= Ins.maxLevel ? '最终关' : '第' + this.curLevel + '关';
            this.nextLevelLabel.text = (this.curLevel + 1) >= Ins.maxLevel ? '最终关' : '第' + (this.curLevel + 1) + '关';
            this.lastLevelLabel.x = 26;
            this.lastLevelLabel.y = 32;
            this.nextLevelLabel.x = 484;
            this.nextLevelLabel.y = 32;
        }

        //关卡分数初始化
        {
            this.scoreLabel = new TextField();
            this.gameUi.addChild(this.scoreLabel);
            this.scoreLabel.textAlign = TEXT_ALIGN.CENTER;
            this.scoreLabel.size = 24;
            this.scoreLabel.textWidth = 304;
            this.scoreLabel.text = '分数：' + this.curScore + '分';
            this.scoreLabel.x = 145;
            this.scoreLabel.y = 83;
        }

        //关卡进度条初始化
        {
            this.levelProgressBg = new Sprite(TextureCache["e1308cff-8f0c-4824-bd1d-b7a1a69760a6"]);
            this.gameUi.addChild(this.levelProgressBg);
            this.levelProgressBg.x = this.gameUi.width * 0.5 - this.levelProgressBg.width * 0.5 - 5;
            this.levelProgressBg.y = 23;
            this.levelProgress = new Sprite(TextureCache["59a1460a-cfa9-4f10-a3ed-00978c2c8a5e"]);
            this.levelProgress.y = 1.5;
            this.levelProgress.x = 2;
            this.levelProgressBg.addChild(this.levelProgress);
            let mask = new Shape();
            mask.beginFill(66, 0.5);
            mask.drawRoundedRect(0, 0, this.levelProgress.width, this.levelProgress.height, 30, 30, 30, 30);
            mask.endFill();
            this.levelProgressBg.addChild(mask);
            mask.x = 2;
            mask.y = 1.5;
            this.levelProgress.mask = mask;
            this.levelProgress.anchorY = this.levelProgress.height * 0.5;
            let scale = this.goneCarCnt / this.maxCarCnt;
            this.levelProgress.x = scale * this.levelProgress.width - this.levelProgress.width + 2;
        }
    }

    addEvent() {
        this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this);
        this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.carTurning, this);
        GDispatcher.addEventListener(Ins.msg.trackTurnOver, this.tackTurnOverHandler, this);
        GDispatcher.addEventListener(Ins.msg.vipStartTurn,this.vipCarTurning,this);
    }

    onEnterFrame() {
        // console.log("11111111111")
        if (this.gameState != 1) return;
        this.track1();
        this.track2();
        this.updateCar();
    }

    initNewLevel() {
        
        console.log("初始化时间",Ins.levelInitTrackerTime[this.curLevel])
        this.randomInitTime = Ins.levelInitTrackerTime[this.curLevel];
        this.trackInitTime1 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
        this.trackInitTime2 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
        this.trackTime1 = this.trackInitTime1 - 1;
        this.trackTime2 = this.trackInitTime2 - 1
        Ins.speedY = 10+Math.floor(this.curLevel/4);
        Ins.speedX = 6;
        this.isChangeDir = false;
        this.curPlayerCarL = true;
        // this.gameGroup.y = Ins.stageH - this.gameBg.height;
        this.gameGroup.y =  (document.body.clientHeight - 1624)*0.5+200 
        Ins.effectLayer.y = -(document.body.clientHeight - 1624)*0.5-200;
        this.maxCarCnt = this.levelInfo[this.curLevel-1].num;
        this.setUi();
        this.initPlayerCar();
    }

    vipCarTurning(){
        if(this.gameState == 0) return;
        Ins.canTouch = false;
        let car = this.playerCarArr.shift();
            this.turningCar.push(car);
            for (let i = 0; i < this.playerCarArr.length; i++) {
                if (i == 0) {
                    this.playerCarArr[i].setDistance(0);
                } else {
                    if (this.curPlayerCarL) {
                        this.playerCarArr[i].setDistance(this.playerCarArr[0].x - this.playerCarArr[i].x);
                    } else {
                        this.playerCarArr[i].setDistance(this.playerCarArr[i].x - this.playerCarArr[0].x);
                    }

                }
                this.playerCarArr[i].changeState(Ins.CarState.goStage);

            }
            car.changeState(Ins.CarState.turning);
    }

    carTurning() {
        if (this.gameState == 0 || !Ins.canTouch) return;
        Ins.canTouch = false;
        if (!this.playerCarArr[0].isVip) {
            let car = this.playerCarArr.shift();
            this.turningCar.push(car);
            for (let i = 0; i < this.playerCarArr.length; i++) {
                // this.playerCarArr[i].setDistance(this.playerCarArr[i].distance - car.x)
                if (i == 0) {
                    this.playerCarArr[i].setDistance(0);
                } else {
                    if (this.curPlayerCarL) {
                        this.playerCarArr[i].setDistance(this.playerCarArr[0].x - this.playerCarArr[i].x);
                    } else {
                        this.playerCarArr[i].setDistance(this.playerCarArr[i].x - this.playerCarArr[0].x);
                    }

                }

                this.playerCarArr[i].changeState(Ins.CarState.goStage);

            }
            car.changeState(Ins.CarState.turning);

        } else {

        }
    }

    /**复活 */
    resurrection() {
        console.log("复活嘛", this.turningCar, this.playerCarArr);
        let car = this.turningCar.pop();
        this.playerCarArr.unshift(car);

        for (let i = 0; i < this.playerCarArr.length; i++) {
            let car = this.playerCarArr[i];
            if (this.curPlayerCarL) {
                if (i < 1) {
                    car.x = -100;
                    car.setDistance(0);
                } else {
                    car.x = this.playerCarArr[i - 1].x - (car.carImg.height + 60);
                    car.setDistance(this.playerCarArr[0].x - car.x);
                }
                car.y = 820;
                car.rotation = 90;

            } else {
                if (i < 1) {
                    car.x = Ins.stageW + 100;
                    car.setDistance(0);
                } else {
                    car.x = this.playerCarArr[i - 1].x + (car.carImg.height + 60);
                    car.setDistance(car.x - this.playerCarArr[0].x);
                }
                car.y = 2422;
                car.rotation = -90;
            }
            car.changeState(Ins.CarState.goStage);
        }
        this.gameState = 1;
    }

    /**游戏结束 */
    gameOver() {
        console.log("游戏结束");
        this.gameState = 0;
        Ins.canTouch = false;
        Tween.get(this).wait(700).call(()=>{this.dispatchOutEvent('gameOver',{score:this.curScore,level:this.curLevel});})
        // setTimeout(() => {
        //     this.resurrection();
        // }, 700);
    }

    /**新的一关 */
    newlevel() {
        this.curLevel++;
        if(this.curLevel>Ins.maxLevel){
            /**通关 */
            this.gameClear();
            return;
        }
        for (let i = 0; i < Ins.trackCarArr1.length; i++) {
            this.gameGroup.removeChild(Ins.trackCarArr1[i]);
            Ins.trackCarArr1.splice(i, 1);
            i--;
        }

        for (let i = 0; i < Ins.trackCarArr2.length; i++) {
            this.gameGroup.removeChild(Ins.trackCarArr2[i]);
            Ins.trackCarArr2.splice(i, 1);
            i--;
        }

        for (let i = 0; i < this.playerCarArr.length; i++) {
            this.gameGroup.removeChild(this.playerCarArr[i]);
            this.playerCarArr.splice(i, 1);
            i--;
        }

        for (let i = 0; i < this.turningCar.length; i++) {
            this.gameGroup.removeChild(this.turningCar[i]);
            this.turningCar.splice(i, 1);
            i--;
        }
        
        this.goneCarCnt = 0;
        
        

        this.initNewLevel();
    }

    gameClear(){
        this.gameState = 0;
        Ins.canTouch = false;
        this.dispatchOutEvent("gameClear",{score:this.curScore,level:this.curLevel})
    }

    /**更新车辆 */
    updateCar() {
        for (let i = 0; i < Ins.trackCarArr1.length; i++) {
            if (this.curPlayerCarL) {
                for (let j = 0; j < this.turningCar.length; j++) {
                    let rect1 = Ins.trackCarArr1[i];
                    let rect2 = this.turningCar[j];
                    let obb1 = new OBB(new vector(rect1.x, rect1.y), rect1.carImg.width, rect1.carImg.height+5, rect1.rotation);
                    let obb2 = new OBB(new vector(rect2.x, rect2.y), rect2.carImg.width, rect2.carImg.height+5, rect2.rotation);
                    if (detectorOBBvsOBB(obb1, obb2)) {
                        this.turningCar[j].turnFailed();
                        this.gameOver();
                        return;
                    }
                }
            }
            if (Ins.trackCarArr1[i].updateSelf()) {
                this.gameGroup.removeChild(Ins.trackCarArr1[i]);
                Ins.trackCarArr1.splice(i, 1);
                i--;
            }
        }

        for (let i = 0; i < Ins.trackCarArr2.length; i++) {
            if (!this.curPlayerCarL) {
                for (let j = 0; j < this.turningCar.length; j++) {
                    let rect1 = Ins.trackCarArr2[i];
                    let rect2 = this.turningCar[j];
                    let obb1 = new OBB(new vector(rect1.x, rect1.y), rect1.carImg.width, rect1.carImg.height+5, rect1.rotation);
                    let obb2 = new OBB(new vector(rect2.x, rect2.y), rect2.carImg.width, rect2.carImg.height+2, rect2.rotation);
                    if (detectorOBBvsOBB(obb1, obb2)) {
                        this.turningCar[j].turnFailed();
                        this.gameOver();
                        return;
                    }
                }
            }
            if (Ins.trackCarArr2[i].updateSelf()) {
                this.gameGroup.removeChild(Ins.trackCarArr2[i]);
                Ins.trackCarArr2.splice(i, 1);
                i--;
            }
        }

        if (this.playerCarInitOver) {
            for (let i = 0; i < this.playerCarArr.length; i++) {
                this.playerCarArr[i].updateSelf(i);
            }
        }

        for (let i = 0; i < this.turningCar.length; i++) {
            this.turningCar[i].updateSelf();
            if (this.turningCar[i].turnOver) {
                if (this.turningCar[i].dir == 0) {
                    Ins.trackCarArr1.push(this.turningCar[i]);
                } else if (this.turningCar[i].dir == 1) {
                    Ins.trackCarArr2.push(this.turningCar[i]);
                }
                this.turningCar.splice(i, 1);
                i--;
            }
        }
    }

    /**赛道1的更新 */
    track1() {
        this.trackTime1++;
        if (this.trackTime1 % this.trackInitTime1 == 0) {
            this.trackTime1 = 0;
            this.trackInitTime1 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
            this.initTrackCar(1);

        }
    }

    /**赛道2的更新 */
    track2() {
        this.trackTime2++;
        if (this.trackTime2 % this.trackInitTime2 == 0) {
            this.trackTime2 = 0;
            this.trackInitTime2 = getRandomValue(this.randomInitTime[0], this.randomInitTime[1]);
            this.initTrackCar(2);
        }
    }

    initTrackCar(trackIndex) {
        let car = new Car();
        this.gameGroup.addChildAt(car,2);
        let x = 0;
        let y = 0;
        let dir = 0;
        if (trackIndex == 1) {
            x = 302;
            y = -100;
            dir = 3;
            Ins.trackCarArr1.push(car);
        } else {
            x = 451;
            y = 3348;
            dir = 2;
            Ins.trackCarArr2.push(car);
        }
        let data = {
            type: 0,
            isVip: false,
            x: x,
            y: y,
            dir: dir
        }
        car.initUi(data)

    }

    /**生成一组玩家车辆 */
    initPlayerCar() {
        let randomIndex = Math.floor(Math.random()*this.maxCarCnt*0.5);
        for (let i = 0; i < this.maxCarCnt * 0.5; i++) {
            if(i==randomIndex){
                this.initOnePlayerCar(true);
            }else{
                this.initOnePlayerCar(false);
            }
            
        }
        // console.log(this.playerCarArr);
        this.playerCarInitOver = true;
    }

    /**生成一个玩家车辆 */
    initOnePlayerCar(isVip) {
        let car = new Car();
        this.gameGroup.addChild(car);
        let x = -100;
        let y = 0;
        let dir = 0;
        let isLast = false;
        if (this.curPlayerCarL) {
            y = 820;
            dir = 0;
        } else {
            y = 2422;
            dir = 1;
        }
        if (this.playerCarArr.length >= this.maxCarCnt * 0.5 - 1) {
            isLast = true;
        }

        let data = {
            type: 1,
            isVip: isVip,
            x: x,
            y: y,
            dir: dir,
            isLast: isLast
        }
        car.initUi(data)
        if (this.curPlayerCarL) {
            if (this.playerCarArr.length < 1) {
                car.x = -100;
                car.setDistance(0);
            } else {
                car.x = this.playerCarArr[this.playerCarArr.length - 1].x - (car.carImg.height + 60);
                car.setDistance(this.playerCarArr[0].x - car.x);
            }

        } else {
            if (this.playerCarArr.length < 1) {
                car.x = Ins.stageW + 100;
                car.setDistance(0);
            } else {
                car.x = this.playerCarArr[this.playerCarArr.length - 1].x + (car.carImg.height + 60);
                car.setDistance(car.x - this.playerCarArr[0].x);
            }
        }
        this.playerCarArr.push(car);
    }

    /**当前赛道玩家车辆转弯结束 */
    tackTurnOverHandler(e) {
        
        if (e.data.isVip) {
            let scoreTips = new ScoreTips();
            this.gameGroup.addChild(scoreTips);
            scoreTips.init(2,e.data.x,e.data.y-50)
            this.curScore += 2;
        } else {
            let scoreTips = new ScoreTips();
            this.gameGroup.addChild(scoreTips);
            scoreTips.init(1,e.data.x,e.data.y-50)
            this.curScore += 1;
        }
        this.goneCarCnt++;
        this.setUi();
        if (this.goneCarCnt >= this.maxCarCnt) {
            /**过关 */
            if(this.curLevel>(Ins.maxLevel-1)){
                /**通关 */
                this.gameClear();
                return;
            }
            this.dispatchOutEvent("clearLevel",{score:this.curScore,level:this.curLevel});
            // setTimeout(() => {
            //     this.newlevel()
            // },1500)

        } else if (!this.isChangeDir && this.goneCarCnt >= this.maxCarCnt * 0.5) {
            Ins.canTouch = false;
            this.isChangeDir = true;
            this.curPlayerCarL = !this.curPlayerCarL;
            Tween.get(this).wait(500).call(()=>{this.changeGameGroup()})
        }
    }

    changeGameGroup(){
        if (this.curPlayerCarL) {
            // console.log("设置y",document.body.clientHeight);
            let stageH = document.body.clientHeight;
            Tween.get(this.gameGroup).to({
                y: (stageH - 1624)*0.5+200
            }, 600).call(() => {
                Ins.effectLayer.y = Math.abs((stageH - 1624)*0.5+200);
                // Ins.canTouch = false;
                this.initPlayerCar();
            })
        } else {
            let stageH = document.body.clientHeight;
            Tween.get(this.gameGroup).to({
                y: (Ins.stageH - this.gameBg.height)
            }, 600).call(() => {
                Ins.effectLayer.y = this.gameBg.height - Ins.stageH;
                // Ins.canTouch = true;
                this.initPlayerCar();
            })
        }
    }

    setUi() {
        let maxScore = 0;
        let totalCar = 0;
        for(let i=0;i<this.curLevel;i++){
            totalCar += this.levelInfo[i].num;
        }
        // console.log("管卡信息",this.curLevel,this.levelInfo,totalCar);
        maxScore = totalCar+2*this.curLevel;
        this.scoreLabel.text = '分数：' + this.curScore + '分'+'/'+maxScore+'分';
        let scale = this.goneCarCnt / this.maxCarCnt;
        this.levelProgress.x = scale * this.levelProgress.width - this.levelProgress.width + 2;
        this.lastLevelLabel.text = this.curLevel >= Ins.maxLevel ? '最终关' : '第' + this.curLevel + '关';
        this.nextLevelLabel.text = (this.curLevel + 1) >= Ins.maxLevel ? '最终关' : '第' + (this.curLevel + 1) + '关';
    }

    async onEvent(type, payload) {
        switch (type) {
            case 'init':
                this.initUi();
                break;
            case 'reset':
                // this.reset();
                break;
            case 'start':
                injectProp(this, payload);
                // console.log("a",payload);
                this.start();
                break;
            case 'pause':
                // this.pause();
                break;
            case 'resume':
                // this.start();
                break;
            case 'stop':
                // this.stop();
                break;
            case 'assetsComplete':
                await loadSvgaList();
                this.dispatchOutEvent("loadOver");
                break;
            case 'resurrection':
                this.resurrection();
                break;
            case 'nextLevel':
                this.newlevel();
                break;
            case 'remove':
                this.removeFromViewPort();
                break;
            default:
                console.log(type);
        }
    }

    start() {
        this.gameState = 1;
    }
}