export * from './log';

import isuuidImport from 'isuuid';

/**
 * @type 1
 * @name 判断是不是uuid
 * @desc 判断是不是uuid
 * @outputs {success:'是', failed:'不是'}
 * @param {string} text 文本
 */
export function isuuid(text) {
	return isuuidImport(text);
}

/**
 * @type 1
 * @name ua判断
 * @desc 对ua进行正则判断，用于判断环境
 * @outputs {success:'匹配成功', failed:'匹配失败'}
 * @param {string|RegExp} reg 正则表达式
 * @param {string} [flags] 正则标识
 */
export function testUA(reg, flags) {
	let regexp = reg;
	if (typeof reg === 'string') {
		regexp = new RegExp(reg, flags);
	}
	return {
		type: navigator.userAgent.match(regexp) ? 'success' : 'failed',
	}
}

/**
 * @type 1
 * @name 返回前一个页面
 * @desc 返回前一个历史记录的页面
 */
export function back() {
	history.back();
}
